/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.spark.IcebergSpark;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestPartitionedWritesAsSelect
extends TestBaseWithCatalog {
    @Parameter(index=3)
    private String targetTable;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, targetTable = {3}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), SparkCatalogConfig.HADOOP.catalogName() + ".default.target_table"}};
    }

    @BeforeEach
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s", this.targetTable);
    }

    @TestTemplate
    public void testInsertAsSelectAppend() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (days(ts), category)", this.targetTable);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY ts,category", this.targetTable, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable)).as("Should have 15 rows after insert", new Object[0])).isEqualTo((Object)15L);
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    @TestTemplate
    public void testInsertAsSelectWithBucket() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (bucket(8, data))", this.targetTable);
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket8", (DataType)DataTypes.StringType, (int)8);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY iceberg_bucket8(data)", this.targetTable, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable)).as("Should have 15 rows after insert", new Object[0])).isEqualTo((Object)15L);
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    @TestTemplate
    public void testInsertAsSelectWithTruncate() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (truncate(data, 4), truncate(id, 4))", this.targetTable);
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_string4", (DataType)DataTypes.StringType, (int)4);
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_long4", (DataType)DataTypes.LongType, (int)4);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY iceberg_truncate_string4(data),iceberg_truncate_long4(id)", this.targetTable, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable)).as("Should have 15 rows after insert", new Object[0])).isEqualTo((Object)15L);
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    private void insertData(int repeatCounter) {
        IntStream.range(0, repeatCounter).forEach(i -> this.sql("INSERT INTO %s VALUES (13, '1', 'bgd16', timestamp('2021-11-10 11:20:10')),(21, '2', 'bgd13', timestamp('2021-11-10 11:20:10')), (12, '3', 'bgd14', timestamp('2021-11-10 11:20:10')),(222, '3', 'bgd15', timestamp('2021-11-10 11:20:10')),(45, '4', 'bgd16', timestamp('2021-11-10 11:20:10'))", this.tableName));
    }

    private List<Object[]> currentData() {
        return this.rowsToJava(spark.sql("SELECT * FROM " + this.tableName + " order by id").collectAsList());
    }
}

