/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.joda.time.DateTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestTimestampWithoutZone
extends CatalogTestBase {
    private static final String NEW_TABLE_NAME = "created_table";
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)3, (String)"tsz", (Type)Types.TimestampType.withZone())});
    private final List<Object[]> values = ImmutableList.of((Object)this.row(1L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")), (Object)this.row(2L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")), (Object)this.row(3L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")));

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false")}};
    }

    @BeforeEach
    public void createTables() {
        this.validationCatalog.createTable(this.tableIdent, SCHEMA);
    }

    @AfterEach
    public void removeTables() {
        this.validationCatalog.dropTable(this.tableIdent, true);
        this.sql("DROP TABLE IF EXISTS %s", NEW_TABLE_NAME);
    }

    @TestTemplate
    public void testAppendTimestampWithoutZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues((List<Object[]>)ImmutableList.of((Object)this.row(1L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toLocalDateTime("2021-02-01T00:00:00.0")))));
    }

    @TestTemplate
    public void testAppendTimestampWithZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues((List<Object[]>)ImmutableList.of((Object)this.row(1L, this.toTimestamp("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")))));
    }

    @TestTemplate
    public void testCreateAsSelectWithTimestampWithoutZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", NEW_TABLE_NAME, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", NEW_TABLE_NAME)).as("Should have " + this.values.size() + " row", new Object[0])).isEqualTo((Object)this.values.size());
        this.assertEquals("Row data should match expected", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", NEW_TABLE_NAME));
    }

    @TestTemplate
    public void testCreateNewTableShouldHaveTimestampWithZoneIcebergType() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", NEW_TABLE_NAME, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", NEW_TABLE_NAME)).as("Should have " + this.values.size() + " row", new Object[0])).isEqualTo((Object)this.values.size());
        this.assertEquals("Data from created table should match data from base table", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", NEW_TABLE_NAME));
        Table createdTable = this.validationCatalog.loadTable(TableIdentifier.of((String[])new String[]{"default", NEW_TABLE_NAME}));
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withoutZone(), "ts");
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withZone(), "tsz");
    }

    @TestTemplate
    public void testCreateNewTableShouldHaveTimestampWithoutZoneIcebergType() {
        spark.sessionState().catalogManager().currentCatalog().initialize(catalog.name(), new CaseInsensitiveStringMap(this.catalogConfig));
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", NEW_TABLE_NAME, this.tableName);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", NEW_TABLE_NAME)).as("Should have " + this.values.size() + " row", new Object[0])).isEqualTo((Object)this.values.size());
        this.assertEquals("Row data should match expected", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", NEW_TABLE_NAME));
        Table createdTable = this.validationCatalog.loadTable(TableIdentifier.of((String[])new String[]{"default", NEW_TABLE_NAME}));
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withoutZone(), "ts");
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withZone(), "tsz");
    }

    private Timestamp toTimestamp(String value) {
        return new Timestamp(DateTime.parse((String)value).getMillis());
    }

    private LocalDateTime toLocalDateTime(String value) {
        return LocalDateTime.parse(value);
    }

    private String rowToSqlValues(List<Object[]> rows) {
        List rowValues = rows.stream().map(row -> {
            List columns = Arrays.stream(row).map(value -> {
                if (value instanceof Long) {
                    return value.toString();
                }
                if (value instanceof Timestamp) {
                    return String.format("timestamp '%s'", value);
                }
                if (value instanceof LocalDateTime) {
                    return String.format("timestamp_ntz '%s'", value);
                }
                throw new RuntimeException("Type is not supported");
            }).collect(Collectors.toList());
            return "(" + Joiner.on((String)",").join(columns) + ")";
        }).collect(Collectors.toList());
        return Joiner.on((String)",").join(rowValues);
    }

    private void assertFieldsType(Schema actual, Type.PrimitiveType expected, String ... fields) {
        actual.select(fields).asStruct().fields().forEach(field -> Assertions.assertThat((Object)field.type()).isEqualTo((Object)expected));
    }
}

