/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.spark.sql.UnpartitionedWritesTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestUnpartitionedWritesToBranch
extends UnpartitionedWritesTestBase {
    private static final String BRANCH = "test";

    @Override
    @BeforeEach
    public void createTables() {
        super.createTables();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.manageSnapshots().createBranch(BRANCH, table.currentSnapshot().snapshotId()).commit();
        this.sql("REFRESH TABLE " + this.tableName, new Object[0]);
    }

    @Override
    protected String commitTarget() {
        return String.format("%s.branch_%s", this.tableName, BRANCH);
    }

    @Override
    protected String selectTarget() {
        return String.format("%s VERSION AS OF '%s'", this.tableName, BRANCH);
    }

    @TestTemplate
    public void testInsertIntoNonExistingBranchFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO %s.branch_not_exist VALUES (4, 'd'), (5, 'e')", this.tableName)).isInstanceOf(ValidationException.class)).hasMessage("Cannot use branch (does not exist): not_exist");
    }
}

