/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.function.Supplier;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.api.java.JavaSparkContext;

public class JobGroupUtils {
    private static final String JOB_GROUP_ID = SparkContext$.MODULE$.SPARK_JOB_GROUP_ID();
    private static final String JOB_GROUP_DESC = SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION();
    private static final String JOB_INTERRUPT_ON_CANCEL = SparkContext$.MODULE$.SPARK_JOB_INTERRUPT_ON_CANCEL();

    private JobGroupUtils() {
    }

    public static JobGroupInfo getJobGroupInfo(SparkContext sparkContext) {
        String groupId = sparkContext.getLocalProperty(JOB_GROUP_ID);
        String description = sparkContext.getLocalProperty(JOB_GROUP_DESC);
        String interruptOnCancel = sparkContext.getLocalProperty(JOB_INTERRUPT_ON_CANCEL);
        return new JobGroupInfo(groupId, description, Boolean.parseBoolean(interruptOnCancel));
    }

    public static void setJobGroupInfo(SparkContext sparkContext, JobGroupInfo info) {
        sparkContext.setLocalProperty(JOB_GROUP_ID, info.groupId());
        sparkContext.setLocalProperty(JOB_GROUP_DESC, info.description());
        sparkContext.setLocalProperty(JOB_INTERRUPT_ON_CANCEL, String.valueOf(info.interruptOnCancel()));
    }

    public static <T> T withJobGroupInfo(JavaSparkContext sparkContext, JobGroupInfo info, Supplier<T> supplier) {
        return JobGroupUtils.withJobGroupInfo(sparkContext.sc(), info, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withJobGroupInfo(SparkContext sparkContext, JobGroupInfo info, Supplier<T> supplier) {
        JobGroupInfo previousInfo = JobGroupUtils.getJobGroupInfo(sparkContext);
        try {
            JobGroupUtils.setJobGroupInfo(sparkContext, info);
            T t = supplier.get();
            return t;
        }
        finally {
            JobGroupUtils.setJobGroupInfo(sparkContext, previousInfo);
        }
    }
}

