/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkTypeVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VarcharType;

class SparkTypeToType
extends SparkTypeVisitor<Type> {
    private final StructType root;
    private int nextId = 0;

    SparkTypeToType() {
        this.root = null;
    }

    SparkTypeToType(StructType root) {
        this.root = root;
        this.nextId = root.fields().length;
    }

    private int getNextId() {
        int next = this.nextId++;
        return next;
    }

    @Override
    public Type struct(StructType struct, List<Type> types) {
        StructField[] fields = struct.fields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.length);
        boolean isRoot = this.root == struct;
        for (int i = 0; i < fields.length; ++i) {
            String doc;
            StructField field = fields[i];
            Type type = types.get(i);
            int id = isRoot ? i : this.getNextId();
            String string = doc = field.getComment().isDefined() ? (String)field.getComment().get() : null;
            if (field.nullable()) {
                newFields.add(Types.NestedField.optional((int)id, (String)field.name(), (Type)type, (String)doc));
                continue;
            }
            newFields.add(Types.NestedField.required((int)id, (String)field.name(), (Type)type, (String)doc));
        }
        return Types.StructType.of((List)newFields);
    }

    @Override
    public Type field(StructField field, Type typeResult) {
        return typeResult;
    }

    @Override
    public Type array(ArrayType array, Type elementType) {
        if (array.containsNull()) {
            return Types.ListType.ofOptional((int)this.getNextId(), (Type)elementType);
        }
        return Types.ListType.ofRequired((int)this.getNextId(), (Type)elementType);
    }

    @Override
    public Type map(MapType map, Type keyType, Type valueType) {
        if (map.valueContainsNull()) {
            return Types.MapType.ofOptional((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofRequired((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
    }

    @Override
    public Type atomic(DataType atomic) {
        if (atomic instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (atomic instanceof IntegerType || atomic instanceof ShortType || atomic instanceof ByteType) {
            return Types.IntegerType.get();
        }
        if (atomic instanceof LongType) {
            return Types.LongType.get();
        }
        if (atomic instanceof FloatType) {
            return Types.FloatType.get();
        }
        if (atomic instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (atomic instanceof StringType || atomic instanceof CharType || atomic instanceof VarcharType) {
            return Types.StringType.get();
        }
        if (atomic instanceof DateType) {
            return Types.DateType.get();
        }
        if (atomic instanceof TimestampType) {
            return Types.TimestampType.withZone();
        }
        if (atomic instanceof TimestampNTZType) {
            return Types.TimestampType.withoutZone();
        }
        if (atomic instanceof DecimalType) {
            return Types.DecimalType.of((int)((DecimalType)atomic).precision(), (int)((DecimalType)atomic).scale());
        }
        if (atomic instanceof BinaryType) {
            return Types.BinaryType.get();
        }
        throw new UnsupportedOperationException("Not a supported type: " + atomic.catalogString());
    }
}

