/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.ClosingIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.UnmodifiableIterator;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.JobGroupUtils;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.actions.FileInfo;
import org.apache.iceberg.spark.actions.ManifestFileBean;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseSparkAction<ThisT> {
    protected static final String MANIFEST = "Manifest";
    protected static final String MANIFEST_LIST = "Manifest List";
    protected static final String STATISTICS_FILES = "Statistics Files";
    protected static final String OTHERS = "Others";
    protected static final String FILE_PATH = "file_path";
    protected static final String LAST_MODIFIED = "last_modified";
    protected static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    protected static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Logger LOG = LoggerFactory.getLogger(BaseSparkAction.class);
    private static final AtomicInteger JOB_COUNTER = new AtomicInteger();
    private static final int DELETE_NUM_RETRIES = 3;
    private static final int DELETE_GROUP_SIZE = 100000;
    private final SparkSession spark;
    private final JavaSparkContext sparkContext;
    private final Map<String, String> options = Maps.newHashMap();

    protected BaseSparkAction(SparkSession spark) {
        this.spark = spark;
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    protected SparkSession spark() {
        return this.spark;
    }

    protected JavaSparkContext sparkContext() {
        return this.sparkContext;
    }

    protected abstract ThisT self();

    public ThisT option(String name, String value) {
        this.options.put(name, value);
        return this.self();
    }

    public ThisT options(Map<String, String> newOptions) {
        this.options.putAll(newOptions);
        return this.self();
    }

    protected Map<String, String> options() {
        return this.options;
    }

    protected <T> T withJobGroupInfo(JobGroupInfo info, Supplier<T> supplier) {
        return JobGroupUtils.withJobGroupInfo(this.sparkContext, info, supplier);
    }

    protected JobGroupInfo newJobGroupInfo(String groupId, String desc) {
        return new JobGroupInfo(groupId + "-" + JOB_COUNTER.incrementAndGet(), desc);
    }

    protected Table newStaticTable(TableMetadata metadata, FileIO io) {
        StaticTableOperations ops = new StaticTableOperations(metadata, io);
        return new BaseTable((TableOperations)ops, metadata.metadataFileLocation());
    }

    protected Dataset<FileInfo> contentFileDS(Table table) {
        return this.contentFileDS(table, null);
    }

    protected Dataset<FileInfo> contentFileDS(Table table, Set<Long> snapshotIds) {
        Table serializableTable = SerializableTableWithSize.copyOf(table);
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)serializableTable);
        int numShufflePartitions = this.spark.sessionState().conf().numShufflePartitions();
        Dataset manifestBeanDS = this.manifestDF(table, snapshotIds).selectExpr(new String[]{"content", "path", "length", "0 as sequenceNumber", "partition_spec_id as partitionSpecId", "added_snapshot_id as addedSnapshotId"}).dropDuplicates("path", new String[0]).repartition(numShufflePartitions).as(ManifestFileBean.ENCODER);
        return manifestBeanDS.flatMap((FlatMapFunction)new ReadManifest((Broadcast<Table>)tableBroadcast), FileInfo.ENCODER);
    }

    protected Dataset<FileInfo> manifestDS(Table table) {
        return this.manifestDS(table, null);
    }

    protected Dataset<FileInfo> manifestDS(Table table, Set<Long> snapshotIds) {
        return this.manifestDF(table, snapshotIds).select(new Column[]{functions.col((String)"path"), functions.lit((Object)MANIFEST).as("type")}).as(FileInfo.ENCODER);
    }

    private Dataset<Row> manifestDF(Table table, Set<Long> snapshotIds) {
        Dataset<Row> manifestDF = this.loadMetadataTable(table, MetadataTableType.ALL_MANIFESTS);
        if (snapshotIds != null) {
            Column filterCond = functions.col((String)AllManifestsTable.REF_SNAPSHOT_ID.name()).isInCollection(snapshotIds);
            return manifestDF.filter(filterCond);
        }
        return manifestDF;
    }

    protected Dataset<FileInfo> manifestListDS(Table table) {
        return this.manifestListDS(table, null);
    }

    protected Dataset<FileInfo> manifestListDS(Table table, Set<Long> snapshotIds) {
        List manifestLists = ReachableFileUtil.manifestListLocations((Table)table, snapshotIds);
        return this.toFileInfoDS(manifestLists, MANIFEST_LIST);
    }

    protected Dataset<FileInfo> statisticsFileDS(Table table, Set<Long> snapshotIds) {
        List statisticsFiles = ReachableFileUtil.statisticsFilesLocationsForSnapshots((Table)table, snapshotIds);
        return this.toFileInfoDS(statisticsFiles, STATISTICS_FILES);
    }

    protected Dataset<FileInfo> otherMetadataFileDS(Table table) {
        return this.otherMetadataFileDS(table, false);
    }

    protected Dataset<FileInfo> allReachableOtherMetadataFileDS(Table table) {
        return this.otherMetadataFileDS(table, true);
    }

    private Dataset<FileInfo> otherMetadataFileDS(Table table, boolean recursive) {
        ArrayList otherMetadataFiles = Lists.newArrayList();
        otherMetadataFiles.addAll(ReachableFileUtil.metadataFileLocations((Table)table, (boolean)recursive));
        otherMetadataFiles.add(ReachableFileUtil.versionHintLocation((Table)table));
        otherMetadataFiles.addAll(ReachableFileUtil.statisticsFilesLocations((Table)table));
        return this.toFileInfoDS(otherMetadataFiles, OTHERS);
    }

    protected Dataset<Row> loadMetadataTable(Table table, MetadataTableType type) {
        return SparkTableUtil.loadMetadataTable(this.spark, table, type);
    }

    private Dataset<FileInfo> toFileInfoDS(List<String> paths, String type) {
        List fileInfoList = Lists.transform(paths, path -> new FileInfo((String)path, type));
        return this.spark.createDataset(fileInfoList, FileInfo.ENCODER);
    }

    protected DeleteSummary deleteFiles(ExecutorService executorService, Consumer<String> deleteFunc, Iterator<FileInfo> files) {
        DeleteSummary summary = new DeleteSummary();
        Tasks.foreach(files).retry(3).stopRetryOn(new Class[]{NotFoundException.class}).suppressFailureWhenFinished().executeWith(executorService).onFailure((fileInfo, exc) -> {
            String path = fileInfo.getPath();
            String type = fileInfo.getType();
            LOG.warn("Delete failed for {}: {}", new Object[]{type, path, exc});
        }).run(fileInfo -> {
            String path = fileInfo.getPath();
            String type = fileInfo.getType();
            deleteFunc.accept(path);
            summary.deletedFile(path, type);
        });
        return summary;
    }

    protected DeleteSummary deleteFiles(SupportsBulkOperations io, Iterator<FileInfo> files) {
        DeleteSummary summary = new DeleteSummary();
        UnmodifiableIterator fileGroups = Iterators.partition(files, (int)100000);
        Tasks.foreach((Iterator)fileGroups).suppressFailureWhenFinished().run(fileGroup -> BaseSparkAction.deleteFileGroup(fileGroup, io, summary));
        return summary;
    }

    private static void deleteFileGroup(List<FileInfo> fileGroup, SupportsBulkOperations io, DeleteSummary summary) {
        ImmutableListMultimap filesByType = Multimaps.index(fileGroup, FileInfo::getType);
        ListMultimap pathsByType = Multimaps.transformValues((ListMultimap)filesByType, FileInfo::getPath);
        for (Map.Entry entry : pathsByType.asMap().entrySet()) {
            String type = (String)entry.getKey();
            Collection paths = (Collection)entry.getValue();
            int failures = 0;
            try {
                io.deleteFiles((Iterable)paths);
            }
            catch (BulkDeletionFailureException e) {
                failures = e.numberFailedObjects();
            }
            summary.deletedFiles(type, paths.size() - failures);
        }
    }

    private static class ReadManifest
    implements FlatMapFunction<ManifestFileBean, FileInfo> {
        private final Broadcast<Table> table;

        ReadManifest(Broadcast<Table> table) {
            this.table = table;
        }

        public Iterator<FileInfo> call(ManifestFileBean manifest) {
            return new ClosingIterator(this.entries(manifest));
        }

        public CloseableIterator<FileInfo> entries(ManifestFileBean manifest) {
            ManifestContent content = manifest.content();
            FileIO io = ((Table)this.table.getValue()).io();
            Map specs = ((Table)this.table.getValue()).specs();
            ImmutableList proj = ImmutableList.of((Object)DataFile.FILE_PATH.name(), (Object)DataFile.CONTENT.name());
            switch (content) {
                case DATA: {
                    return CloseableIterator.transform((CloseableIterator)ManifestFiles.read((ManifestFile)manifest, (FileIO)io, (Map)specs).select((Collection)proj).iterator(), ReadManifest::toFileInfo);
                }
                case DELETES: {
                    return CloseableIterator.transform((CloseableIterator)ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)io, (Map)specs).select((Collection)proj).iterator(), ReadManifest::toFileInfo);
                }
            }
            throw new IllegalArgumentException("Unsupported manifest content type:" + content);
        }

        static FileInfo toFileInfo(ContentFile<?> file) {
            return new FileInfo(file.path().toString(), file.content().toString());
        }
    }

    static class DeleteSummary {
        private final AtomicLong dataFilesCount = new AtomicLong(0L);
        private final AtomicLong positionDeleteFilesCount = new AtomicLong(0L);
        private final AtomicLong equalityDeleteFilesCount = new AtomicLong(0L);
        private final AtomicLong manifestsCount = new AtomicLong(0L);
        private final AtomicLong manifestListsCount = new AtomicLong(0L);
        private final AtomicLong statisticsFilesCount = new AtomicLong(0L);
        private final AtomicLong otherFilesCount = new AtomicLong(0L);

        DeleteSummary() {
        }

        public void deletedFiles(String type, int numFiles) {
            if (FileContent.DATA.name().equalsIgnoreCase(type)) {
                this.dataFilesCount.addAndGet(numFiles);
            } else if (FileContent.POSITION_DELETES.name().equalsIgnoreCase(type)) {
                this.positionDeleteFilesCount.addAndGet(numFiles);
            } else if (FileContent.EQUALITY_DELETES.name().equalsIgnoreCase(type)) {
                this.equalityDeleteFilesCount.addAndGet(numFiles);
            } else if (BaseSparkAction.MANIFEST.equalsIgnoreCase(type)) {
                this.manifestsCount.addAndGet(numFiles);
            } else if (BaseSparkAction.MANIFEST_LIST.equalsIgnoreCase(type)) {
                this.manifestListsCount.addAndGet(numFiles);
            } else if (BaseSparkAction.STATISTICS_FILES.equalsIgnoreCase(type)) {
                this.statisticsFilesCount.addAndGet(numFiles);
            } else if (BaseSparkAction.OTHERS.equalsIgnoreCase(type)) {
                this.otherFilesCount.addAndGet(numFiles);
            } else {
                throw new ValidationException("Illegal file type: %s", new Object[]{type});
            }
        }

        public void deletedFile(String path, String type) {
            if (FileContent.DATA.name().equalsIgnoreCase(type)) {
                this.dataFilesCount.incrementAndGet();
                LOG.trace("Deleted data file: {}", (Object)path);
            } else if (FileContent.POSITION_DELETES.name().equalsIgnoreCase(type)) {
                this.positionDeleteFilesCount.incrementAndGet();
                LOG.trace("Deleted positional delete file: {}", (Object)path);
            } else if (FileContent.EQUALITY_DELETES.name().equalsIgnoreCase(type)) {
                this.equalityDeleteFilesCount.incrementAndGet();
                LOG.trace("Deleted equality delete file: {}", (Object)path);
            } else if (BaseSparkAction.MANIFEST.equalsIgnoreCase(type)) {
                this.manifestsCount.incrementAndGet();
                LOG.debug("Deleted manifest: {}", (Object)path);
            } else if (BaseSparkAction.MANIFEST_LIST.equalsIgnoreCase(type)) {
                this.manifestListsCount.incrementAndGet();
                LOG.debug("Deleted manifest list: {}", (Object)path);
            } else if (BaseSparkAction.STATISTICS_FILES.equalsIgnoreCase(type)) {
                this.statisticsFilesCount.incrementAndGet();
                LOG.debug("Deleted statistics file: {}", (Object)path);
            } else if (BaseSparkAction.OTHERS.equalsIgnoreCase(type)) {
                this.otherFilesCount.incrementAndGet();
                LOG.debug("Deleted other metadata file: {}", (Object)path);
            } else {
                throw new ValidationException("Illegal file type: %s", new Object[]{type});
            }
        }

        public long dataFilesCount() {
            return this.dataFilesCount.get();
        }

        public long positionDeleteFilesCount() {
            return this.positionDeleteFilesCount.get();
        }

        public long equalityDeleteFilesCount() {
            return this.equalityDeleteFilesCount.get();
        }

        public long manifestsCount() {
            return this.manifestsCount.get();
        }

        public long manifestListsCount() {
            return this.manifestListsCount.get();
        }

        public long statisticsFilesCount() {
            return this.statisticsFilesCount.get();
        }

        public long otherFilesCount() {
            return this.otherFilesCount.get();
        }

        public long totalFilesCount() {
            return this.dataFilesCount() + this.positionDeleteFilesCount() + this.equalityDeleteFilesCount() + this.manifestsCount() + this.manifestListsCount() + this.statisticsFilesCount() + this.otherFilesCount();
        }
    }
}

