/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.function.Function;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.actions.SparkShufflingDataRewriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

class SparkSortDataRewriter
extends SparkShufflingDataRewriter {
    private final SortOrder sortOrder;

    SparkSortDataRewriter(SparkSession spark, Table table) {
        super(spark, table);
        Preconditions.checkArgument((boolean)table.sortOrder().isSorted(), (String)"Cannot sort data without a valid sort order, table '%s' is unsorted and no sort order is provided", (Object)table.name());
        this.sortOrder = table.sortOrder();
    }

    SparkSortDataRewriter(SparkSession spark, Table table, SortOrder sortOrder) {
        super(spark, table);
        Preconditions.checkArgument((sortOrder != null && sortOrder.isSorted() ? 1 : 0) != 0, (Object)"Cannot sort data without a valid sort order, the provided sort order is null or empty");
        this.sortOrder = sortOrder;
    }

    public String description() {
        return "SORT";
    }

    @Override
    protected SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Override
    protected Dataset<Row> sortedDF(Dataset<Row> df, Function<Dataset<Row>, Dataset<Row>> sortFunc) {
        return sortFunc.apply(df);
    }
}

