/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

class ConstantColumnVector
extends ColumnVector {
    private final Type icebergType;
    private final Object constant;
    private final int batchSize;

    ConstantColumnVector(Type icebergType, int batchSize, Object constant) {
        super(icebergType != null ? SparkSchemaUtil.convert(icebergType) : null);
        this.icebergType = icebergType;
        this.constant = constant;
        this.batchSize = batchSize;
    }

    public void close() {
    }

    public boolean hasNull() {
        return this.constant == null;
    }

    public int numNulls() {
        return this.constant == null ? this.batchSize : 0;
    }

    public boolean isNullAt(int rowId) {
        return this.constant == null;
    }

    public boolean getBoolean(int rowId) {
        return (Boolean)this.constant;
    }

    public byte getByte(int rowId) {
        return (Byte)this.constant;
    }

    public short getShort(int rowId) {
        return (Short)this.constant;
    }

    public int getInt(int rowId) {
        return (Integer)this.constant;
    }

    public long getLong(int rowId) {
        return (Long)this.constant;
    }

    public float getFloat(int rowId) {
        return ((Float)this.constant).floatValue();
    }

    public double getDouble(int rowId) {
        return (Double)this.constant;
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + " does not implement getArray");
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + " does not implement getMap");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        return (Decimal)this.constant;
    }

    public UTF8String getUTF8String(int rowId) {
        return (UTF8String)this.constant;
    }

    public byte[] getBinary(int rowId) {
        return (byte[])this.constant;
    }

    public ColumnVector getChild(int ordinal) {
        InternalRow constantAsRow = (InternalRow)this.constant;
        Object childConstant = constantAsRow.get(ordinal, this.childType(ordinal));
        return new ConstantColumnVector(this.childIcebergType(ordinal), this.batchSize, childConstant);
    }

    private Type childIcebergType(int ordinal) {
        Types.StructType icebergTypeAsStruct = (Types.StructType)this.icebergType;
        return ((Types.NestedField)icebergTypeAsStruct.fields().get(ordinal)).type();
    }

    private DataType childType(int ordinal) {
        StructType typeAsStruct = (StructType)this.type;
        return typeAsStruct.fields()[ordinal].dataType();
    }
}

