/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.functions.BucketFunction;
import org.apache.iceberg.spark.functions.DaysFunction;
import org.apache.iceberg.spark.functions.HoursFunction;
import org.apache.iceberg.spark.functions.IcebergVersionFunction;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.iceberg.spark.functions.TruncateFunction;
import org.apache.iceberg.spark.functions.YearsFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;

public class SparkFunctions {
    private static final Map<String, UnboundFunction> FUNCTIONS = ImmutableMap.of((Object)"iceberg_version", (Object)new IcebergVersionFunction(), (Object)"years", (Object)new YearsFunction(), (Object)"months", (Object)new MonthsFunction(), (Object)"days", (Object)new DaysFunction(), (Object)"hours", (Object)new HoursFunction(), (Object)"bucket", (Object)new BucketFunction(), (Object)"truncate", (Object)new TruncateFunction());
    private static final Map<Class<?>, UnboundFunction> CLASS_TO_FUNCTIONS = ImmutableMap.of(YearsFunction.class, (Object)new YearsFunction(), MonthsFunction.class, (Object)new MonthsFunction(), DaysFunction.class, (Object)new DaysFunction(), HoursFunction.class, (Object)new HoursFunction(), BucketFunction.class, (Object)new BucketFunction(), TruncateFunction.class, (Object)new TruncateFunction());
    private static final List<String> FUNCTION_NAMES = ImmutableList.copyOf(FUNCTIONS.keySet());

    private SparkFunctions() {
    }

    public static List<String> list() {
        return FUNCTION_NAMES;
    }

    public static UnboundFunction load(String name) {
        return FUNCTIONS.get(name.toLowerCase(Locale.ROOT));
    }

    public static UnboundFunction loadFunctionByClass(Class<?> functionClass) {
        Class<?> declaringClass = functionClass.getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        return CLASS_TO_FUNCTIONS.get(declaringClass);
    }
}

