/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Zorder;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.ExtendedParser;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.ProcedureInput;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class RewriteDataFilesProcedure
extends BaseProcedure {
    private static final ProcedureParameter TABLE_PARAM = ProcedureParameter.required("table", DataTypes.StringType);
    private static final ProcedureParameter STRATEGY_PARAM = ProcedureParameter.optional("strategy", DataTypes.StringType);
    private static final ProcedureParameter SORT_ORDER_PARAM = ProcedureParameter.optional("sort_order", DataTypes.StringType);
    private static final ProcedureParameter OPTIONS_PARAM = ProcedureParameter.optional("options", STRING_MAP);
    private static final ProcedureParameter WHERE_PARAM = ProcedureParameter.optional("where", DataTypes.StringType);
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{TABLE_PARAM, STRATEGY_PARAM, SORT_ORDER_PARAM, OPTIONS_PARAM, WHERE_PARAM};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("rewritten_data_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("added_data_files_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("rewritten_bytes_count", DataTypes.LongType, false, Metadata.empty()), new StructField("failed_data_files_count", DataTypes.IntegerType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RewriteDataFilesProcedure>(){

            @Override
            protected RewriteDataFilesProcedure doBuild() {
                return new RewriteDataFilesProcedure(this.tableCatalog());
            }
        };
    }

    private RewriteDataFilesProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        ProcedureInput input = new ProcedureInput(this.spark(), this.tableCatalog(), PARAMETERS, args);
        Identifier tableIdent = input.ident(TABLE_PARAM);
        String strategy = input.asString(STRATEGY_PARAM, null);
        String sortOrderString = input.asString(SORT_ORDER_PARAM, null);
        Map<String, String> options = input.asStringMap(OPTIONS_PARAM, (Map<String, String>)ImmutableMap.of());
        String where = input.asString(WHERE_PARAM, null);
        return this.modifyIcebergTable(tableIdent, table -> {
            RewriteDataFiles action = (RewriteDataFiles)this.actions().rewriteDataFiles((Table)table).options(options);
            if (strategy != null || sortOrderString != null) {
                action = this.checkAndApplyStrategy(action, strategy, sortOrderString, table.schema());
            }
            action = this.checkAndApplyFilter(action, where, tableIdent);
            RewriteDataFiles.Result result = (RewriteDataFiles.Result)action.execute();
            return this.toOutputRows(result);
        });
    }

    private RewriteDataFiles checkAndApplyFilter(RewriteDataFiles action, String where, Identifier ident) {
        if (where != null) {
            Expression expression = this.filterExpression(ident, where);
            return action.filter(expression);
        }
        return action;
    }

    private RewriteDataFiles checkAndApplyStrategy(RewriteDataFiles action, String strategy, String sortOrderString, Schema schema) {
        ArrayList zOrderTerms = Lists.newArrayList();
        ArrayList sortOrderFields = Lists.newArrayList();
        if (sortOrderString != null) {
            ExtendedParser.parseSortOrder(this.spark(), sortOrderString).forEach(field -> {
                if (field.term() instanceof Zorder) {
                    zOrderTerms.add((Zorder)field.term());
                } else {
                    sortOrderFields.add(field);
                }
            });
            if (!zOrderTerms.isEmpty() && !sortOrderFields.isEmpty()) {
                throw new IllegalArgumentException("Cannot mix identity sort columns and a Zorder sort expression: " + sortOrderString);
            }
        }
        if (strategy == null || strategy.equalsIgnoreCase("sort")) {
            if (!zOrderTerms.isEmpty()) {
                String[] columnNames = (String[])zOrderTerms.stream().flatMap(zOrder -> zOrder.refs().stream().map(NamedReference::name)).toArray(String[]::new);
                return action.zOrder(columnNames);
            }
            if (!sortOrderFields.isEmpty()) {
                return action.sort(this.buildSortOrder(sortOrderFields, schema));
            }
            return action.sort();
        }
        if (strategy.equalsIgnoreCase("binpack")) {
            RewriteDataFiles rewriteDataFiles = action.binPack();
            if (sortOrderString != null) {
                return rewriteDataFiles.sort(this.buildSortOrder(sortOrderFields, schema));
            }
            return rewriteDataFiles;
        }
        throw new IllegalArgumentException("unsupported strategy: " + strategy + ". Only binpack or sort is supported");
    }

    private SortOrder buildSortOrder(List<ExtendedParser.RawOrderField> rawOrderFields, Schema schema) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        rawOrderFields.forEach(rawField -> builder.sortBy(rawField.term(), rawField.direction(), rawField.nullOrder()));
        return builder.build();
    }

    private InternalRow[] toOutputRows(RewriteDataFiles.Result result) {
        int rewrittenDataFilesCount = result.rewrittenDataFilesCount();
        long rewrittenBytesCount = result.rewrittenBytesCount();
        int addedDataFilesCount = result.addedDataFilesCount();
        int failedDataFilesCount = result.failedDataFilesCount();
        InternalRow row = this.newInternalRow(rewrittenDataFilesCount, addedDataFilesCount, rewrittenBytesCount, failedDataFilesCount);
        return new InternalRow[]{row};
    }

    @Override
    public String description() {
        return "RewriteDataFilesProcedure";
    }
}

