/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class SetCurrentSnapshotProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("snapshot_id", DataTypes.LongType), ProcedureParameter.optional("ref", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("previous_snapshot_id", DataTypes.LongType, true, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<SetCurrentSnapshotProcedure>(){

            @Override
            protected SetCurrentSnapshotProcedure doBuild() {
                return new SetCurrentSnapshotProcedure(this.tableCatalog());
            }
        };
    }

    private SetCurrentSnapshotProcedure(TableCatalog catalog) {
        super(catalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Long snapshotId = args.isNullAt(1) ? null : Long.valueOf(args.getLong(1));
        String ref = args.isNullAt(2) ? null : args.getString(2);
        Preconditions.checkArgument((snapshotId != null && ref == null || snapshotId == null && ref != null ? 1 : 0) != 0, (Object)"Either snapshot_id or ref must be provided, not both");
        return this.modifyIcebergTable(tableIdent, table -> {
            Snapshot previousSnapshot = table.currentSnapshot();
            Long previousSnapshotId = previousSnapshot != null ? Long.valueOf(previousSnapshot.snapshotId()) : null;
            long targetSnapshotId = snapshotId != null ? snapshotId.longValue() : this.toSnapshotId((Table)table, ref);
            table.manageSnapshots().setCurrentSnapshot(targetSnapshotId).commit();
            InternalRow outputRow = this.newInternalRow(previousSnapshotId, targetSnapshotId);
            return new InternalRow[]{outputRow};
        });
    }

    @Override
    public String description() {
        return "SetCurrentSnapshotProcedure";
    }

    private long toSnapshotId(Table table, String refName) {
        SnapshotRef ref = (SnapshotRef)table.refs().get(refName);
        ValidationException.check((ref != null ? 1 : 0) != 0, (String)("Cannot find matching snapshot ID for ref " + refName), (Object[])new Object[0]);
        return ref.snapshotId();
    }
}

