/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionUtil;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.SparkAvroWriter;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.spark.data.SparkParquetWriters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

class SparkAppenderFactory
implements FileAppenderFactory<InternalRow> {
    private final Map<String, String> properties;
    private final Schema writeSchema;
    private final StructType dsSchema;
    private final PartitionSpec spec;
    private final int[] equalityFieldIds;
    private final Schema eqDeleteRowSchema;
    private final Schema posDeleteRowSchema;
    private StructType eqDeleteSparkType = null;
    private StructType posDeleteSparkType = null;

    SparkAppenderFactory(Map<String, String> properties, Schema writeSchema, StructType dsSchema, PartitionSpec spec, int[] equalityFieldIds, Schema eqDeleteRowSchema, Schema posDeleteRowSchema) {
        this.properties = properties;
        this.writeSchema = writeSchema;
        this.dsSchema = dsSchema;
        this.spec = spec;
        this.equalityFieldIds = equalityFieldIds;
        this.eqDeleteRowSchema = eqDeleteRowSchema;
        this.posDeleteRowSchema = posDeleteRowSchema;
    }

    static Builder builderFor(Table table, Schema writeSchema, StructType dsSchema) {
        return new Builder(table, writeSchema, dsSchema);
    }

    private StructType lazyEqDeleteSparkType() {
        if (this.eqDeleteSparkType == null) {
            Preconditions.checkNotNull((Object)this.eqDeleteRowSchema, (Object)"Equality delete row schema shouldn't be null");
            this.eqDeleteSparkType = SparkSchemaUtil.convert(this.eqDeleteRowSchema);
        }
        return this.eqDeleteSparkType;
    }

    private StructType lazyPosDeleteSparkType() {
        if (this.posDeleteSparkType == null) {
            Preconditions.checkNotNull((Object)this.posDeleteRowSchema, (Object)"Position delete row schema shouldn't be null");
            this.posDeleteSparkType = SparkSchemaUtil.convert(this.posDeleteRowSchema);
        }
        return this.posDeleteSparkType;
    }

    public FileAppender<InternalRow> newAppender(OutputFile file, FileFormat fileFormat) {
        return this.newAppender(EncryptionUtil.plainAsEncryptedOutput((OutputFile)file), fileFormat);
    }

    public FileAppender<InternalRow> newAppender(EncryptedOutputFile file, FileFormat fileFormat) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.properties);
        try {
            switch (fileFormat) {
                case PARQUET: {
                    return Parquet.write((EncryptedOutputFile)file).createWriterFunc(msgType -> SparkParquetWriters.buildWriter(this.dsSchema, msgType)).setAll(this.properties).metricsConfig(metricsConfig).schema(this.writeSchema).overwrite().build();
                }
                case AVRO: {
                    return Avro.write((EncryptedOutputFile)file).createWriterFunc(ignored -> new SparkAvroWriter(this.dsSchema)).setAll(this.properties).schema(this.writeSchema).overwrite().build();
                }
                case ORC: {
                    return ORC.write((EncryptedOutputFile)file).createWriterFunc(SparkOrcWriter::new).setAll(this.properties).metricsConfig(metricsConfig).schema(this.writeSchema).overwrite().build();
                }
            }
            throw new UnsupportedOperationException("Cannot write unknown format: " + fileFormat);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public DataWriter<InternalRow> newDataWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        return new DataWriter(this.newAppender(file, format), format, file.encryptingOutputFile().location(), this.spec, partition, file.keyMetadata());
    }

    public EqualityDeleteWriter<InternalRow> newEqDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        Preconditions.checkState((this.equalityFieldIds != null && this.equalityFieldIds.length > 0 ? 1 : 0) != 0, (Object)"Equality field ids shouldn't be null or empty when creating equality-delete writer");
        Preconditions.checkNotNull((Object)this.eqDeleteRowSchema, (Object)"Equality delete row schema shouldn't be null when creating equality-delete writer");
        try {
            switch (format) {
                case PARQUET: {
                    return Parquet.writeDeletes((EncryptedOutputFile)file).createWriterFunc(msgType -> SparkParquetWriters.buildWriter(this.lazyEqDeleteSparkType(), msgType)).overwrite().rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withPartition(partition).equalityFieldIds(this.equalityFieldIds).withKeyMetadata(file.keyMetadata()).buildEqualityWriter();
                }
                case AVRO: {
                    return Avro.writeDeletes((EncryptedOutputFile)file).createWriterFunc(ignored -> new SparkAvroWriter(this.lazyEqDeleteSparkType())).overwrite().rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withPartition(partition).equalityFieldIds(this.equalityFieldIds).withKeyMetadata(file.keyMetadata()).buildEqualityWriter();
                }
                case ORC: {
                    return ORC.writeDeletes((EncryptedOutputFile)file).createWriterFunc(SparkOrcWriter::new).overwrite().rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withPartition(partition).equalityFieldIds(this.equalityFieldIds).withKeyMetadata(file.keyMetadata()).buildEqualityWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write equality-deletes for unsupported file format: " + format);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create new equality delete writer", e);
        }
    }

    public PositionDeleteWriter<InternalRow> newPosDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        try {
            switch (format) {
                case PARQUET: {
                    StructType sparkPosDeleteSchema = SparkSchemaUtil.convert(DeleteSchemaUtil.posDeleteSchema((Schema)this.posDeleteRowSchema));
                    return Parquet.writeDeletes((EncryptedOutputFile)file).createWriterFunc(msgType -> SparkParquetWriters.buildWriter(sparkPosDeleteSchema, msgType)).overwrite().rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withPartition(partition).withKeyMetadata(file.keyMetadata()).transformPaths(path -> UTF8String.fromString((String)path.toString())).buildPositionWriter();
                }
                case AVRO: {
                    return Avro.writeDeletes((EncryptedOutputFile)file).createWriterFunc(ignored -> new SparkAvroWriter(this.lazyPosDeleteSparkType())).overwrite().rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withPartition(partition).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
                case ORC: {
                    return ORC.writeDeletes((EncryptedOutputFile)file).createWriterFunc(SparkOrcWriter::new).overwrite().rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withPartition(partition).withKeyMetadata(file.keyMetadata()).transformPaths(path -> UTF8String.fromString((String)path.toString())).buildPositionWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write pos-deletes for unsupported file format: " + format);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create new equality delete writer", e);
        }
    }

    static class Builder {
        private final Table table;
        private final Schema writeSchema;
        private final StructType dsSchema;
        private PartitionSpec spec;
        private int[] equalityFieldIds;
        private Schema eqDeleteRowSchema;
        private Schema posDeleteRowSchema;

        Builder(Table table, Schema writeSchema, StructType dsSchema) {
            this.table = table;
            this.spec = table.spec();
            this.writeSchema = writeSchema;
            this.dsSchema = dsSchema;
        }

        Builder spec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        Builder equalityFieldIds(int[] newEqualityFieldIds) {
            this.equalityFieldIds = newEqualityFieldIds;
            return this;
        }

        Builder eqDeleteRowSchema(Schema newEqDeleteRowSchema) {
            this.eqDeleteRowSchema = newEqDeleteRowSchema;
            return this;
        }

        Builder posDelRowSchema(Schema newPosDelRowSchema) {
            this.posDeleteRowSchema = newPosDelRowSchema;
            return this;
        }

        SparkAppenderFactory build() {
            Preconditions.checkNotNull((Object)this.table, (Object)"Table must not be null");
            Preconditions.checkNotNull((Object)this.writeSchema, (Object)"Write Schema must not be null");
            Preconditions.checkNotNull((Object)this.dsSchema, (Object)"DS Schema must not be null");
            if (this.equalityFieldIds != null) {
                Preconditions.checkNotNull((Object)this.eqDeleteRowSchema, (Object)"Equality Field Ids and Equality Delete Row Schema must be set together");
            }
            if (this.eqDeleteRowSchema != null) {
                Preconditions.checkNotNull((Object)this.equalityFieldIds, (Object)"Equality Field Ids and Equality Delete Row Schema must be set together");
            }
            return new SparkAppenderFactory(this.table.properties(), this.writeSchema, this.dsSchema, this.spec, this.equalityFieldIds, this.eqDeleteRowSchema, this.posDeleteRowSchema);
        }
    }
}

