/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.BranchOptions;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.datasources.v2.CreateOrReplaceBranchExec$;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0013'\u0001VB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u000b\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B+\t\u0011\u0005\u0004!Q3A\u0005\u0002\tD\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006Ia\u0019\u0005\t]\u0002\u0011)\u001a!C\u0001_\"A1\u000f\u0001B\tB\u0003%\u0001\u000f\u0003\u0005u\u0001\tU\r\u0011\"\u0001p\u0011!)\bA!E!\u0002\u0013\u0001\b\"\u0002<\u0001\t\u00039\b\"C@\u0001\u0011\u000b\u0007I\u0011IA\u0001\u0011\u001d\t\t\u0003\u0001C)\u0003GAq!a\f\u0001\t\u0003\n\t\u0004C\u0005\u0002>\u0001\t\t\u0011\"\u0001\u0002@!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003K\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"a\u001b\u0001#\u0003%\t!!\u001c\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005M\u0004\"CA<\u0001E\u0005I\u0011AA=\u0011%\ti\bAI\u0001\n\u0003\tI\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003+\u0003\u0011\u0011!C\u0001\u0003/C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005M\u0006!!A\u0005\u0002\u0005U\u0006\"CA]\u0001\u0005\u0005I\u0011IA^\u000f%\tyLJA\u0001\u0012\u0003\t\tM\u0002\u0005&M\u0005\u0005\t\u0012AAb\u0011\u00191x\u0004\"\u0001\u0002R\"I\u00111[\u0010\u0002\u0002\u0013\u0015\u0013Q\u001b\u0005\n\u0003/|\u0012\u0011!CA\u00033D\u0011\"a: \u0003\u0003%\t)!;\t\u0013\u0005mx$!A\u0005\n\u0005u(!G\"sK\u0006$Xm\u0014:SKBd\u0017mY3Ce\u0006t7\r[#yK\u000eT!a\n\u0015\u0002\u0005Y\u0014$BA\u0015+\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005-b\u0013!C3yK\u000e,H/[8o\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001'\u0011\u0001aG\u000f!\u0011\u0005]BT\"\u0001\u0014\n\u0005e2#!\u0004,3\u0007>lW.\u00198e\u000bb,7\r\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0004Qe>$Wo\u0019;\u0011\u0005m\n\u0015B\u0001\"=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019\u0017\r^1m_\u001e,\u0012!\u0012\t\u0003\r*k\u0011a\u0012\u0006\u0003\u0007\"S!!\u0013\u0017\u0002\u0013\r|gN\\3di>\u0014\u0018BA&H\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013!B5eK:$X#A(\u0011\u0005\u0019\u0003\u0016BA)H\u0005)IE-\u001a8uS\u001aLWM]\u0001\u0007S\u0012,g\u000e\u001e\u0011\u0002\r\t\u0014\u0018M\\2i+\u0005)\u0006C\u0001,^\u001d\t96\f\u0005\u0002Yy5\t\u0011L\u0003\u0002[i\u00051AH]8pizJ!\u0001\u0018\u001f\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039r\nqA\u0019:b]\u000eD\u0007%A\u0007ce\u0006t7\r[(qi&|gn]\u000b\u0002GB\u0011Am[\u0007\u0002K*\u0011amZ\u0001\bY><\u0017nY1m\u0015\tA\u0017.A\u0003qY\u0006t7O\u0003\u0002kY\u0005A1-\u0019;bYf\u001cH/\u0003\u0002mK\ni!I]1oG\"|\u0005\u000f^5p]N\faB\u0019:b]\u000eDw\n\u001d;j_:\u001c\b%A\u0004sKBd\u0017mY3\u0016\u0003A\u0004\"aO9\n\u0005Id$a\u0002\"p_2,\u0017M\\\u0001\te\u0016\u0004H.Y2fA\u0005Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t\u00031IgMT8u\u000bbL7\u000f^:!\u0003\u0019a\u0014N\\5u}Q9\u00010\u001f>|yvt\bCA\u001c\u0001\u0011\u0015\u0019U\u00021\u0001F\u0011\u0015iU\u00021\u0001P\u0011\u0015\u0019V\u00021\u0001V\u0011\u0015\tW\u00021\u0001d\u0011\u0015qW\u00021\u0001q\u0011\u0015!X\u00021\u0001q\u0003\u0019yW\u000f\u001e9viV\u0011\u00111\u0001\t\u0007\u0003\u000b\ty!!\u0006\u000f\t\u0005\u001d\u00111\u0002\b\u00041\u0006%\u0011\"A\u001f\n\u0007\u00055A(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00111\u0003\u0002\u0004'\u0016\f(bAA\u0007yA!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c%\f1\"\u001a=qe\u0016\u001c8/[8og&!\u0011qDA\r\u0005%\tE\u000f\u001e:jEV$X-A\u0002sk:$\"!!\n\u0011\r\u0005\u0015\u0011qBA\u0014!\u0011\tI#a\u000b\u000e\u0003%L1!!\fj\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0019MLW\u000e\u001d7f'R\u0014\u0018N\\4\u0015\u0007U\u000b\u0019\u0004C\u0004\u00026A\u0001\r!a\u000e\u0002\u00135\f\u0007PR5fY\u0012\u001c\bcA\u001e\u0002:%\u0019\u00111\b\u001f\u0003\u0007%sG/\u0001\u0003d_BLH#\u0004=\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY\u0005C\u0004D#A\u0005\t\u0019A#\t\u000f5\u000b\u0002\u0013!a\u0001\u001f\"91+\u0005I\u0001\u0002\u0004)\u0006bB1\u0012!\u0003\u0005\ra\u0019\u0005\b]F\u0001\n\u00111\u0001q\u0011\u001d!\u0018\u0003%AA\u0002A\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002R)\u001aQ)a\u0015,\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0018=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\nIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002j)\u001aq*a\u0015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u000e\u0016\u0004+\u0006M\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003kR3aYA*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a\u001f+\u0007A\f\u0019&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\u000bAA[1wC&\u0019a,a\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00033\u000by\nE\u0002<\u00037K1!!(=\u0005\r\te.\u001f\u0005\n\u0003CS\u0012\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAT!\u0019\tI+a,\u0002\u001a6\u0011\u00111\u0016\u0006\u0004\u0003[c\u0014AC2pY2,7\r^5p]&!\u0011\u0011WAV\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007A\f9\fC\u0005\u0002\"r\t\t\u00111\u0001\u0002\u001a\u00061Q-];bYN$2\u0001]A_\u0011%\t\t+HA\u0001\u0002\u0004\tI*A\rDe\u0016\fG/Z(s%\u0016\u0004H.Y2f\u0005J\fgn\u00195Fq\u0016\u001c\u0007CA\u001c '\u0011y\u0012Q\u0019!\u0011\u0017\u0005\u001d\u0017QZ#P+\u000e\u0004\b\u000f_\u0007\u0003\u0003\u0013T1!a3=\u0003\u001d\u0011XO\u001c;j[\u0016LA!a4\u0002J\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001c\u0015\u0005\u0005\u0005\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0015!B1qa2LH#\u0004=\u0002\\\u0006u\u0017q\\Aq\u0003G\f)\u000fC\u0003DE\u0001\u0007Q\tC\u0003NE\u0001\u0007q\nC\u0003TE\u0001\u0007Q\u000bC\u0003bE\u0001\u00071\rC\u0003oE\u0001\u0007\u0001\u000fC\u0003uE\u0001\u0007\u0001/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0018q\u001f\t\u0006w\u00055\u0018\u0011_\u0005\u0004\u0003_d$AB(qi&|g\u000eE\u0005<\u0003g,u*V2qa&\u0019\u0011Q\u001f\u001f\u0003\rQ+\b\u000f\\37\u0011!\tIpIA\u0001\u0002\u0004A\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0010\u0005\u0003\u0002\u0006\n\u0005\u0011\u0002\u0002B\u0002\u0003\u000f\u0013aa\u00142kK\u000e$\b")
public class CreateOrReplaceBranchExec
extends V2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final String branch;
    private final BranchOptions branchOptions;
    private final boolean replace;
    private final boolean ifNotExists;
    private volatile boolean bitmap$0;

    public static Option<Tuple6<TableCatalog, Identifier, String, BranchOptions, Object, Object>> unapply(CreateOrReplaceBranchExec createOrReplaceBranchExec) {
        return CreateOrReplaceBranchExec$.MODULE$.unapply(createOrReplaceBranchExec);
    }

    public static Function1<Tuple6<TableCatalog, Identifier, String, BranchOptions, Object, Object>, CreateOrReplaceBranchExec> tupled() {
        return CreateOrReplaceBranchExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<String, Function1<BranchOptions, Function1<Object, Function1<Object, CreateOrReplaceBranchExec>>>>>> curried() {
        return CreateOrReplaceBranchExec$.MODULE$.curried();
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public String branch() {
        return this.branch;
    }

    public BranchOptions branchOptions() {
        return this.branchOptions;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private Seq<Attribute> output$lzycompute() {
        CreateOrReplaceBranchExec createOrReplaceBranchExec = this;
        synchronized (createOrReplaceBranchExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        return !this.bitmap$0 ? this.output$lzycompute() : this.output;
    }

    public Seq<InternalRow> run() {
        ManageSnapshots manageSnapshots;
        Table table = this.catalog().loadTable(this.ident());
        if (table instanceof SparkTable) {
            ManageSnapshots manageSnapshots2;
            SparkTable sparkTable = (SparkTable)table;
            Long snapshotId = (Long)this.branchOptions().snapshotId().orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)sparkTable.table().currentSnapshot()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.snapshotId()))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1)).orNull(Predef$.MODULE$.$conforms());
            Preconditions.checkArgument((snapshotId != null ? 1 : 0) != 0, (String)"Cannot complete create or replace branch operation on %s, main has no snapshot", (Object[])new Object[]{this.ident()});
            manageSnapshots = sparkTable.table().manageSnapshots();
            if (!this.replace()) {
                SnapshotRef ref = (SnapshotRef)sparkTable.table().refs().get(this.branch());
                if (ref != null && this.ifNotExists()) {
                    return Nil$.MODULE$;
                }
                manageSnapshots2 = manageSnapshots.createBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId));
            } else {
                manageSnapshots2 = manageSnapshots.replaceBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId));
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(54).append("Cannot create or replace branch on non-Iceberg table: ").append(table).toString());
        }
        Object object = this.branchOptions().numSnapshots().nonEmpty() ? manageSnapshots.setMinSnapshotsToKeep(this.branch(), (int)BoxesRunTime.unboxToLong((Object)this.branchOptions().numSnapshots().get())) : BoxedUnit.UNIT;
        Object object2 = this.branchOptions().snapshotRetain().nonEmpty() ? manageSnapshots.setMaxSnapshotAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRetain().get())) : BoxedUnit.UNIT;
        Object object3 = this.branchOptions().snapshotRefRetain().nonEmpty() ? manageSnapshots.setMaxRefAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRefRetain().get())) : BoxedUnit.UNIT;
        manageSnapshots.commit();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(36).append("CreateOrReplace branch: ").append(this.branch()).append(" for table: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted()).toString();
    }

    public CreateOrReplaceBranchExec copy(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean replace, boolean ifNotExists) {
        return new CreateOrReplaceBranchExec(catalog, ident, branch, branchOptions, replace, ifNotExists);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public String copy$default$3() {
        return this.branch();
    }

    public BranchOptions copy$default$4() {
        return this.branchOptions();
    }

    public boolean copy$default$5() {
        return this.replace();
    }

    public boolean copy$default$6() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateOrReplaceBranchExec";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.catalog();
                break;
            }
            case 1: {
                object = this.ident();
                break;
            }
            case 2: {
                object = this.branch();
                break;
            }
            case 3: {
                object = this.branchOptions();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.replace());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateOrReplaceBranchExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateOrReplaceBranchExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateOrReplaceBranchExec createOrReplaceBranchExec = (CreateOrReplaceBranchExec)((Object)x$1);
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = createOrReplaceBranchExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = createOrReplaceBranchExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        String string = this.branch();
        String string2 = createOrReplaceBranchExec.branch();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        BranchOptions branchOptions = this.branchOptions();
        BranchOptions branchOptions2 = createOrReplaceBranchExec.branchOptions();
        if (branchOptions == null) {
            if (branchOptions2 != null) {
                return false;
            }
        } else if (!((Object)branchOptions).equals(branchOptions2)) return false;
        if (this.replace() != createOrReplaceBranchExec.replace()) return false;
        if (this.ifNotExists() != createOrReplaceBranchExec.ifNotExists()) return false;
        if (!createOrReplaceBranchExec.canEqual((Object)this)) return false;
        return true;
    }

    public CreateOrReplaceBranchExec(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean replace, boolean ifNotExists) {
        this.catalog = catalog;
        this.ident = ident;
        this.branch = branch;
        this.branchOptions = branchOptions;
        this.replace = replace;
        this.ifNotExists = ifNotExists;
    }
}

