/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAddFilesProcedure
extends SparkExtensionsTestBase {
    private final String sourceTableName = "source_table";
    private File fileTableDir;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final List<Object[]> emptyQueryResult = Lists.newArrayList();
    private static final StructField[] struct = new StructField[]{new StructField("id", DataTypes.IntegerType, true, Metadata.empty()), new StructField("name", DataTypes.StringType, true, Metadata.empty()), new StructField("dept", DataTypes.StringType, true, Metadata.empty()), new StructField("subdept", DataTypes.StringType, true, Metadata.empty())};
    private static final Dataset<Row> unpartitionedDF = spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", "hr", "communications"}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", "hr", "salary"}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", "hr", "communications"}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", "facilities", "all"})), new StructType(struct)).repartition(1);
    private static final Dataset<Row> singleNullRecordDF = spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{null, null, null, null})), new StructType(struct)).repartition(1);
    private static final Dataset<Row> partitionedDF = unpartitionedDF.select("name", new String[]{"dept", "subdept", "id"});
    private static final Dataset<Row> compositePartitionedDF = unpartitionedDF.select("name", new String[]{"subdept", "id", "dept"});
    private static final Dataset<Row> compositePartitionedNullRecordDF = singleNullRecordDF.select("name", new String[]{"subdept", "id", "dept"});
    private static final Dataset<Row> weirdColumnNamesDF = unpartitionedDF.select(new Column[]{unpartitionedDF.col("id"), unpartitionedDF.col("subdept"), unpartitionedDF.col("dept"), unpartitionedDF.col("name").as("naMe")});
    private static final StructField[] dateStruct = new StructField[]{new StructField("id", DataTypes.IntegerType, true, Metadata.empty()), new StructField("name", DataTypes.StringType, true, Metadata.empty()), new StructField("ts", DataTypes.DateType, true, Metadata.empty()), new StructField("dept", DataTypes.StringType, true, Metadata.empty())};
    private static final Dataset<Row> dateDF = spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", TestAddFilesProcedure.toDate("2021-01-01"), "01"}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", TestAddFilesProcedure.toDate("2021-01-01"), "01"}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", TestAddFilesProcedure.toDate("2021-01-02"), "02"}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", TestAddFilesProcedure.toDate("2021-01-02"), "02"})), new StructType(dateStruct)).repartition(2);

    public TestAddFilesProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void setupTempDirs() {
        try {
            this.fileTableDir = this.temp.newFolder();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void dropTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{"source_table"});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void addDataUnpartitioned() {
        this.createUnpartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Ignore
    public void addDataUnpartitionedOrc() {
        this.createUnpartitionedFileTable("orc");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`orc`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addAvroFile() throws Exception {
        Assume.assumeFalse((boolean)this.catalogName.equals("spark_catalog"));
        Schema schema = (Schema)SchemaBuilder.record((String)"record").fields().requiredInt("id").requiredString("data").endRecord();
        GenericData.Record record1 = new GenericData.Record(schema);
        record1.put("id", (Object)1L);
        record1.put("data", (Object)"a");
        GenericData.Record record2 = new GenericData.Record(schema);
        record2.put("id", (Object)2L);
        record2.put("data", (Object)"b");
        File outputFile = this.temp.newFile("test.avro");
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, outputFile);
        dataFileWriter.append((Object)record1);
        dataFileWriter.append((Object)record2);
        dataFileWriter.close();
        String createIceberg = "CREATE TABLE %s (id Long, data String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, outputFile.getPath()});
        Assert.assertEquals((Object)1L, (Object)result);
        ArrayList expected = Lists.newArrayList((Object[])new Object[][]{{1L, "a"}, {2L, "b"}});
        this.assertEquals("Iceberg table contains correct data", expected, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        List actualRecordCount = this.sql("select %s from %s.files", new Object[]{DataFile.RECORD_COUNT.name(), this.tableName});
        ArrayList expectedRecordCount = Lists.newArrayList();
        expectedRecordCount.add(new Object[]{2L});
        this.assertEquals("Iceberg file metadata should have correct metadata count", expectedRecordCount, actualRecordCount);
    }

    @Ignore
    public void addDataUnpartitionedAvro() {
        this.createUnpartitionedFileTable("avro");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataUnpartitionedHive() {
        this.createUnpartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataUnpartitionedExtraCol() {
        this.createUnpartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String, foo string) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataUnpartitionedMissingCol() {
        this.createUnpartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataPartitionedMissingCol() {
        this.createPartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)8L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataPartitioned() {
        this.createPartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)8L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Ignore
    public void addDataPartitionedOrc() {
        this.createPartitionedFileTable("orc");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)8L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Ignore
    public void addDataPartitionedAvro() {
        this.createPartitionedFileTable("avro");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`avro`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)8L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataPartitionedHive() {
        this.createPartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)8L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addPartitionToPartitioned() {
        this.createPartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addPartitionToPartitionedSnapshotIdInheritanceEnabledInTwoRuns() {
        this.createPartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)TBLPROPERTIES ('%s'='true')";
        this.sql(createIceberg, new Object[]{this.tableName, "compatibility.snapshot-id-inheritance.enabled"});
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 2))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id < 3 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
        String manifestPath = (String)((Object[])this.sql("select path from %s.manifests", new Object[]{this.tableName}).get(0))[0];
        Pattern uuidPattern = Pattern.compile("[a-f0-9]{8}(?:-[a-f0-9]{4}){4}[a-f0-9]{8}");
        Matcher matcher = uuidPattern.matcher(manifestPath);
        Assert.assertTrue((String)"verify manifest path has uuid", (boolean)matcher.find());
    }

    @Test
    public void addDataPartitionedByDateToPartitioned() {
        this.createDatePartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, date Date) USING iceberg PARTITIONED BY (date)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('date', '2021-01-01'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, date FROM %s WHERE date = '2021-01-01' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, date FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addDataPartitionedVerifyPartitionTypeInferredCorrectly() {
        this.createTableWithTwoPartitions("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, date Date, dept String) USING iceberg PARTITIONED BY (date, dept)";
        this.sql(createIceberg, new Object[]{this.tableName});
        this.sql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('date', '2021-01-01'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        String sqlFormat = "SELECT id, name, dept, date FROM %s WHERE date = '2021-01-01' and dept= '01' ORDER BY id";
        this.assertEquals("Iceberg table contains correct data", this.sql(sqlFormat, new Object[]{"source_table"}), this.sql(sqlFormat, new Object[]{this.tableName}));
    }

    @Test
    public void addFilteredPartitionsToPartitioned() {
        this.createCompositePartitionedTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id, dept)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addFilteredPartitionsToPartitioned2() {
        this.createCompositePartitionedTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id, dept)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', 'hr'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)6L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE dept = 'hr' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addFilteredPartitionsToPartitionedWithNullValueFilteringOnId() {
        this.createCompositePartitionedTableWithNullValueInPartitionColumn("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id, dept)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addFilteredPartitionsToPartitionedWithNullValueFilteringOnDept() {
        this.createCompositePartitionedTableWithNullValueInPartitionColumn("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id, dept)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', 'hr'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)6L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE dept = 'hr' ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addWeirdCaseHiveTable() {
        this.createWeirdCaseTable();
        String createIceberg = "CREATE TABLE %s (id Integer, `naMe` String, dept String, subdept String) USING iceberg PARTITIONED BY (`naMe`)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '%s', map('naMe', 'John Doe'))", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result);
        List expected = this.sql("SELECT id, `naMe`, dept, subdept from %s ORDER BY id", new Object[]{"source_table"}).stream().filter(r -> r[1].equals("John Doe")).collect(Collectors.toList());
        Assert.assertEquals((String)"If this assert breaks it means that Spark has fixed the pushdown issue", (long)0L, (long)this.sql("SELECT id, `naMe`, dept, subdept from %s WHERE `naMe` = 'John Doe' ORDER BY id", new Object[]{"source_table"}).size());
        Assert.assertEquals((String)"We should be able to pushdown mixed case partition keys", (long)2L, (long)this.sql("SELECT id, `naMe`, dept, subdept FROM %s WHERE `naMe` = 'John Doe' ORDER BY id", new Object[]{this.tableName}).size());
        this.assertEquals("Iceberg table contains correct data", expected, this.sql("SELECT id, `naMe`, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void addPartitionToPartitionedHive() {
        this.createPartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.add_files('%s', '%s', map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void invalidDataImport() {
        this.createPartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        AssertHelpers.assertThrows((String)"Should forbid adding of partitioned data to unpartitioned table", IllegalArgumentException.class, (String)"Cannot use partition filter with an unpartitioned table", () -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('id', 1))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()}));
        AssertHelpers.assertThrows((String)"Should forbid adding of partitioned data to unpartitioned table", IllegalArgumentException.class, (String)"Cannot add partitioned files to an unpartitioned table", () -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()}));
    }

    @Test
    public void invalidDataImportPartitioned() {
        this.createUnpartitionedFileTable("parquet");
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        AssertHelpers.assertThrows((String)"Should forbid adding with a mismatching partition spec", IllegalArgumentException.class, (String)"is greater than the number of partitioned columns", () -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('x', '1', 'y', '2'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()}));
        AssertHelpers.assertThrows((String)"Should forbid adding with partition spec with incorrect columns", IllegalArgumentException.class, (String)"specified partition filter refers to columns that are not partitioned", () -> this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`', map('dept', '2'))", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()}));
    }

    @Test
    public void addTwice() {
        this.createPartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result1 = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result1);
        Object result2 = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 2))", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result2);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 ORDER BY id", new Object[]{this.tableName}));
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 2 ORDER BY id", new Object[]{"source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 2 ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void duplicateDataPartitioned() {
        this.createPartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        AssertHelpers.assertThrows((String)"Should not allow adding duplicate files", IllegalStateException.class, (String)"Cannot complete import because data files to be imported already exist within the target table", () -> this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"}));
    }

    @Test
    public void duplicateDataPartitionedAllowed() {
        this.createPartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result1 = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1))", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result1);
        Object result2 = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', 1),check_duplicate_files => false)", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result2);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT id, name, dept, subdept FROM %s WHERE id = 1 UNION ALL SELECT id, name, dept, subdept FROM %s WHERE id = 1", new Object[]{"source_table", "source_table"}), this.sql("SELECT id, name, dept, subdept FROM %s", new Object[]{this.tableName, this.tableName}));
    }

    @Test
    public void duplicateDataUnpartitioned() {
        this.createUnpartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        AssertHelpers.assertThrows((String)"Should not allow adding duplicate files", IllegalStateException.class, (String)"Cannot complete import because data files to be imported already exist within the target table", () -> this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"}));
    }

    @Test
    public void duplicateDataUnpartitionedAllowed() {
        this.createUnpartitionedHiveTable();
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object result1 = this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result1);
        Object result2 = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s',check_duplicate_files => false)", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)2L, (Object)result2);
        this.assertEquals("Iceberg table contains correct data", this.sql("SELECT * FROM (SELECT * FROM %s UNION ALL SELECT * from %s) ORDER BY id", new Object[]{"source_table", "source_table"}), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testEmptyImportDoesNotThrow() {
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object pathResult = this.scalarSql("CALL %s.system.add_files('%s', '`parquet`.`%s`')", new Object[]{this.catalogName, this.tableName, this.fileTableDir.getAbsolutePath()});
        Assert.assertEquals((Object)0L, (Object)pathResult);
        this.assertEquals("Iceberg table contains no added data when importing from an empty path", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        String createHive = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        Object tableResult = this.scalarSql("CALL %s.system.add_files('%s', '%s')", new Object[]{this.catalogName, this.tableName, "source_table"});
        Assert.assertEquals((Object)0L, (Object)tableResult);
        this.assertEquals("Iceberg table contains no added data when importing from an empty table", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testPartitionedImportFromEmptyPartitionDoesNotThrow() {
        this.createPartitionedHiveTable();
        int emptyPartitionId = 999;
        this.sql("ALTER TABLE %s ADD PARTITION (id = '%d') LOCATION '%d'", new Object[]{"source_table", 999, 999});
        String createIceberg = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING iceberg PARTITIONED BY (id)";
        this.sql(createIceberg, new Object[]{this.tableName});
        Object tableResult = this.scalarSql("CALL %s.system.add_files(table => '%s', source_table => '%s', partition_filter => map('id', %d))", new Object[]{this.catalogName, this.tableName, "source_table", 999});
        Assert.assertEquals((Object)0L, (Object)tableResult);
        this.assertEquals("Iceberg table contains no added data when importing from an empty table", emptyQueryResult, this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    private static Date toDate(String value) {
        return new Date(DateTime.parse((String)value).getMillis());
    }

    private void createUnpartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        unpartitionedDF.write().insertInto("source_table");
        unpartitionedDF.write().insertInto("source_table");
    }

    private void createPartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        partitionedDF.write().insertInto("source_table");
        partitionedDF.write().insertInto("source_table");
    }

    private void createCompositePartitionedTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        compositePartitionedDF.write().insertInto("source_table");
        compositePartitionedDF.write().insertInto("source_table");
    }

    private void createCompositePartitionedTableWithNullValueInPartitionColumn(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) USING %s PARTITIONED BY (id, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        Dataset unionedDF = compositePartitionedDF.unionAll(compositePartitionedNullRecordDF).select("name", new String[]{"subdept", "id", "dept"}).repartition(1);
        unionedDF.write().insertInto("source_table");
        unionedDF.write().insertInto("source_table");
    }

    private void createWeirdCaseTable() {
        String createParquet = "CREATE TABLE %s (id Integer, subdept String, dept String) PARTITIONED BY (`naMe` String) STORED AS parquet";
        this.sql(createParquet, new Object[]{"source_table"});
        weirdColumnNamesDF.write().insertInto("source_table");
        weirdColumnNamesDF.write().insertInto("source_table");
    }

    private void createUnpartitionedHiveTable() {
        String createHive = "CREATE TABLE %s (id Integer, name String, dept String, subdept String) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        unpartitionedDF.write().insertInto("source_table");
        unpartitionedDF.write().insertInto("source_table");
    }

    private void createPartitionedHiveTable() {
        String createHive = "CREATE TABLE %s (name String, dept String, subdept String) PARTITIONED BY (id Integer) STORED AS parquet";
        this.sql(createHive, new Object[]{"source_table"});
        partitionedDF.write().insertInto("source_table");
        partitionedDF.write().insertInto("source_table");
    }

    private void createDatePartitionedFileTable(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, date Date) USING %s PARTITIONED BY (date) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        dateDF.select("id", new String[]{"name", "ts"}).write().insertInto("source_table");
    }

    private void createTableWithTwoPartitions(String format) {
        String createParquet = "CREATE TABLE %s (id Integer, name String, date Date, dept String) USING %s PARTITIONED BY (date, dept) LOCATION '%s'";
        this.sql(createParquet, new Object[]{"source_table", format, this.fileTableDir.getAbsolutePath()});
        dateDF.write().insertInto("source_table");
    }
}

