/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Row;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestChangelogTable
extends SparkExtensionsTestBase {
    private final int formatVersion;

    @Parameterized.Parameters(name="formatVersion = {0}, catalogName = {1}, implementation = {2}, config = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{1, SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}, {2, SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties()}};
    }

    public TestChangelogTable(int formatVersion, String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.formatVersion = formatVersion;
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testDataFilters() {
        this.createTableWithDefaultRows();
        this.sql("INSERT INTO %s VALUES (3, 'c')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap3 = table.currentSnapshot();
        this.sql("DELETE FROM %s WHERE id = 3", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap4 = table.currentSnapshot();
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{3, "c", "INSERT", 2, snap3.snapshotId()}), (Object)this.row(new Object[]{3, "c", "DELETE", 3, snap4.snapshotId()})), this.sql("SELECT * FROM %s.changes WHERE id = 3 ORDER BY _change_ordinal, id", new Object[]{this.tableName}));
    }

    @Test
    public void testOverwrites() {
        this.createTableWithDefaultRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap2 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap3 = table.currentSnapshot();
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "DELETE", 0, snap3.snapshotId()}), (Object)this.row(new Object[]{-2, "b", "INSERT", 0, snap3.snapshotId()})), this.changelogRecords(snap2, snap3));
    }

    @Test
    public void testQueryWithTimeRange() {
        this.createTable();
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        long rightAfterSnap1 = this.waitUntilAfter(snap1.timestampMillis());
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        long rightAfterSnap2 = this.waitUntilAfter(snap2.timestampMillis());
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap3 = table.currentSnapshot();
        this.assertEquals("Should have expected changed rows only from snapshot 3", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "DELETE", 0, snap3.snapshotId()}), (Object)this.row(new Object[]{-2, "b", "INSERT", 0, snap3.snapshotId()})), this.changelogRecords(rightAfterSnap2, snap3.timestampMillis()));
        this.assertEquals("Should have expected changed rows only from snapshot 3", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "DELETE", 0, snap3.snapshotId()}), (Object)this.row(new Object[]{-2, "b", "INSERT", 0, snap3.snapshotId()})), this.changelogRecords(snap2.timestampMillis(), snap3.timestampMillis()));
        this.assertEquals("Should have expected changed rows from snapshot 2 and 3", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "INSERT", 0, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "b", "DELETE", 1, snap3.snapshotId()}), (Object)this.row(new Object[]{-2, "b", "INSERT", 1, snap3.snapshotId()})), this.changelogRecords(rightAfterSnap1, snap3.timestampMillis()));
        this.assertEquals("Should have expected changed rows up to the current snapshot", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "INSERT", 0, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "b", "DELETE", 1, snap3.snapshotId()}), (Object)this.row(new Object[]{-2, "b", "INSERT", 1, snap3.snapshotId()})), this.changelogRecords(rightAfterSnap1, null));
    }

    @Test
    public void testTimeRangeValidation() {
        this.createTableWithDefaultRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap2 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap3 = table.currentSnapshot();
        long rightAfterSnap3 = this.waitUntilAfter(snap3.timestampMillis());
        AssertHelpers.assertThrows((String)"Should fail if start time is after end time", IllegalArgumentException.class, () -> this.changelogRecords(snap3.timestampMillis(), snap2.timestampMillis()));
        AssertHelpers.assertThrows((String)"Should fail if start time is after the current snapshot", IllegalArgumentException.class, () -> this.changelogRecords(rightAfterSnap3, null));
    }

    @Test
    public void testMetadataDeletes() {
        this.createTableWithDefaultRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap2 = table.currentSnapshot();
        this.sql("DELETE FROM %s WHERE data = 'a'", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap3 = table.currentSnapshot();
        Assert.assertEquals((String)"Operation must match", (Object)"delete", (Object)snap3.operation());
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", "DELETE", 0, snap3.snapshotId()})), this.changelogRecords(snap2, snap3));
    }

    @Test
    public void testExistingEntriesInNewDataManifestsAreIgnored() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg PARTITIONED BY (data) TBLPROPERTIES (  '%s' = '%d',  '%s' = '1',  '%s' = 'true' )", new Object[]{this.tableName, "format-version", this.formatVersion, "commit.manifest.min-count-to-merge", "commit.manifest-merge.enabled"});
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        Assert.assertEquals((String)"Manifest number must match", (long)1L, (long)snap2.dataManifests(table.io()).size());
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", "INSERT", 0, snap2.snapshotId()})), this.changelogRecords(snap1, snap2));
    }

    @Test
    public void testManifestRewritesAreIgnored() {
        this.createTableWithDefaultRows();
        this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Num snapshots must match", (long)3L, (long)Iterables.size((Iterable)table.snapshots()));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "INSERT"}), (Object)this.row(new Object[]{2, "INSERT"})), this.sql("SELECT id, _change_type FROM %s.changes ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testMetadataColumns() {
        this.createTableWithDefaultRows();
        List rows = this.sql("SELECT id, _file, _pos, _deleted, _spec_id, _partition FROM %s.changes ORDER BY id", new Object[]{this.tableName});
        String file1 = ((Object[])rows.get(0))[1].toString();
        Assert.assertTrue((boolean)file1.startsWith("file:/"));
        String file2 = ((Object[])rows.get(1))[1].toString();
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, file1, 0L, false, 0, this.row(new Object[]{"a"})}), (Object)this.row(new Object[]{2, file2, 0L, false, 0, this.row(new Object[]{"b"})})), rows);
    }

    private void createTableWithDefaultRows() {
        this.createTable();
        this.insertDefaultRows();
    }

    private void createTable() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg PARTITIONED BY (data) TBLPROPERTIES (  '%s' = '%d' )", new Object[]{this.tableName, "format-version", this.formatVersion});
    }

    private void insertDefaultRows() {
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
    }

    private List<Object[]> changelogRecords(Snapshot startSnapshot, Snapshot endSnapshot) {
        DataFrameReader reader = spark.read();
        if (startSnapshot != null) {
            reader = reader.option("start-snapshot-id", startSnapshot.snapshotId());
        }
        if (endSnapshot != null) {
            reader = reader.option("end-snapshot-id", endSnapshot.snapshotId());
        }
        return this.rowsToJava(this.collect(reader));
    }

    private List<Object[]> changelogRecords(Long startTimestamp, Long endTimeStamp) {
        DataFrameReader reader = spark.read();
        if (startTimestamp != null) {
            reader = reader.option("start-timestamp", startTimestamp.longValue());
        }
        if (endTimeStamp != null) {
            reader = reader.option("end-timestamp", endTimeStamp.longValue());
        }
        return this.rowsToJava(this.collect(reader));
    }

    private List<Row> collect(DataFrameReader reader) {
        return reader.table(this.tableName + "." + "changes").orderBy("_change_ordinal", new String[]{"_commit_snapshot_id", "_change_type", "id"}).collectAsList();
    }
}

