/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestConflictValidation
extends SparkExtensionsTestBase {
    public TestConflictValidation(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTables() {
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg PARTITIONED BY (id)TBLPROPERTIES('format-version'='2','write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", new Object[]{this.tableName});
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testOverwriteFilterSerializableIsolation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting new data files should throw exception", ValidationException.class, (String)"Found conflicting files that can contain records matching ref(name=\"id\") == 1:", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwriteFilterSerializableIsolation2() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1' and data='b'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting new delete files should throw exception", ValidationException.class, (String)"Found new conflicting delete files that can apply to records matching ref(name=\"id\") == 1:", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwriteFilterSerializableIsolation3() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting deleted data files should throw exception", ValidationException.class, (String)"Found conflicting deleted files that can contain records matching ref(name=\"id\") == 1:", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwriteFilterNoSnapshotIdValidation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting new data files should throw exception", ValidationException.class, (String)"Found conflicting files that can contain records matching ref(name=\"id\") == 1:", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwriteFilterSnapshotIsolation() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1' and data='b'", new Object[]{this.tableName});
        table.refresh();
        ArrayList conflictingRecords = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        Dataset conflictingDf = spark.createDataFrame((List)conflictingRecords, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting new delete files should throw exception", ValidationException.class, (String)"Found new conflicting delete files that can apply to records matching ref(name=\"id\") == 1:", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwriteFilterSnapshotIsolation2() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwrite(functions.col((String)"id").equalTo((Object)1));
    }

    @Test
    public void testOverwritePartitionSerializableIsolation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting deleted data files should throw exception", ValidationException.class, (String)"Found conflicting files that can contain records matching partitions [id=1]", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
    }

    @Test
    public void testOverwritePartitionSnapshotIsolation() throws Exception {
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE data='a'", new Object[]{this.tableName});
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting deleted data files should throw exception", ValidationException.class, (String)"Found new conflicting delete files that can apply to records matching [id=1]", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @Test
    public void testOverwritePartitionSnapshotIsolation2() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("DELETE FROM %s WHERE id='1'", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).coalesce(1).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting deleted data files should throw exception", ValidationException.class, (String)"Found conflicting deleted files that can apply to records matching [id=1]", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long newSnapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(newSnapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @Test
    public void testOverwritePartitionSnapshotIsolation3() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SNAPSHOT.toString()).overwritePartitions();
    }

    @Test
    public void testOverwritePartitionNoSnapshotIdValidation() throws Exception {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a")});
        spark.createDataFrame((List)records, SimpleRecord.class).writeTo(this.tableName).append();
        Dataset conflictingDf = spark.createDataFrame((List)records, SimpleRecord.class);
        AssertHelpers.assertThrowsCause((String)"Conflicting deleted data files should throw exception", ValidationException.class, (String)"Found conflicting files that can contain records matching partitions [id=1]", () -> {
            try {
                conflictingDf.writeTo(this.tableName).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
        table.refresh();
        long snapshotId = table.currentSnapshot().snapshotId();
        conflictingDf.writeTo(this.tableName).option("validate-from-snapshot-id", String.valueOf(snapshotId)).option("isolation-level", IsolationLevel.SERIALIZABLE.toString()).overwritePartitions();
    }
}

