/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.extensions.TestDelete;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestCopyOnWriteDelete
extends TestDelete {
    public TestCopyOnWriteDelete(String catalogName, String implementation, Map<String, String> config, String fileFormat, Boolean vectorized, String distributionMode) {
        super(catalogName, implementation, config, fileFormat, vectorized, distributionMode);
    }

    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"write.delete.mode", (Object)RowLevelOperationMode.COPY_ON_WRITE.modeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void testDeleteWithConcurrentTableRefresh() throws Exception {
        Assume.assumeTrue((boolean)this.catalogName.equalsIgnoreCase("testhive"));
        this.createAndInitUnpartitionedTable();
        this.createOrReplaceView("deleted_id", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.delete.isolation-level", "snapshot"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> deleteFuture = executorService.submit(() -> {
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.tableName});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            GenericRecord record = GenericRecord.create((Schema)table.schema());
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (shouldAppend.get() && barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    table.newFastAppend().appendFile(dataFile).commit();
                    this.sleep(10L);
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(deleteFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IllegalStateException.class)).hasMessageContaining("the table has been concurrently modified");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        Assert.assertTrue((String)"Timeout", (boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES));
    }
}

