/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.Employee;
import org.apache.iceberg.spark.extensions.SparkRowLevelOperationsTestBase;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromIcebergTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.OptimizeMetadataOnlyDeleteFromTable;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class TestDelete
extends SparkRowLevelOperationsTestBase {
    public TestDelete(String catalogName, String implementation, Map<String, String> config, String fileFormat, Boolean vectorized, String distributionMode) {
        super(catalogName, implementation, config, fileFormat, vectorized, distributionMode);
    }

    @BeforeClass
    public static void setupSparkConf() {
        spark.conf().set("spark.sql.shuffle.partitions", "4");
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS deleted_id", new Object[0]);
        this.sql("DROP TABLE IF EXISTS deleted_dep", new Object[0]);
    }

    @Test
    public void testDeleteWithoutScanningTable() throws Exception {
        this.createAndInitPartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(3, "hr"));
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        List manifestLocations = table.currentSnapshot().allManifests(table.io()).stream().map(ManifestFile::path).collect(Collectors.toList());
        this.withUnavailableLocations(manifestLocations, () -> {
            LogicalPlan parsed = this.parsePlan("DELETE FROM %s WHERE dep = 'hr'", this.tableName);
            DeleteFromIcebergTable analyzed = (DeleteFromIcebergTable)spark.sessionState().analyzer().execute(parsed);
            Assert.assertTrue((String)"Should have rewrite plan", (boolean)analyzed.rewritePlan().isDefined());
            DeleteFromIcebergTable optimized = (DeleteFromIcebergTable)OptimizeMetadataOnlyDeleteFromTable.apply((LogicalPlan)analyzed);
            Assert.assertTrue((String)"Should discard rewrite plan", (boolean)optimized.rewritePlan().isEmpty());
        });
        this.sql("DELETE FROM %s WHERE dep = 'hr'", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteFileThenMetadataDelete() throws Exception {
        Assume.assumeFalse((String)"Avro does not support metadata delete", (boolean)this.fileFormat.equals("avro"));
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s AS t WHERE t.id IS NULL", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Set dataFilesBefore = TestHelpers.dataFiles((Table)table);
        this.sql("DELETE FROM %s AS t WHERE t.id = 1", new Object[]{this.tableName});
        Set dataFilesAfter = TestHelpers.dataFiles((Table)table);
        Assert.assertTrue((String)"Data file should have been removed", (dataFilesBefore.size() > dataFilesAfter.size() ? 1 : 0) != 0);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithFalseCondition() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 1 AND id > 20", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 2 snapshots", (long)2L, (long)Iterables.size((Iterable)table.snapshots()));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteFromEmptyTable() {
        this.createAndInitUnpartitionedTable();
        this.sql("DELETE FROM %s WHERE id IN (1)", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE dep = 'hr'", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 2 snapshots", (long)2L, (long)Iterables.size((Iterable)table.snapshots()));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testExplain() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("EXPLAIN DELETE FROM %s WHERE id <=> 1", new Object[]{this.tableName});
        this.sql("EXPLAIN DELETE FROM %s WHERE true", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 1 snapshot", (long)1L, (long)Iterables.size((Iterable)table.snapshots()));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithAlias() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s AS t WHERE t.id IS NULL", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithDynamicFileFiltering() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(3, "hr"));
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        this.sql("DELETE FROM %s WHERE id = 2", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 3 snapshots", (long)3L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteNonExistingRecords() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s AS t WHERE t.id > 10", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 2 snapshots", (long)2L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.fileFormat.equals("orc") || this.fileFormat.equals("parquet")) {
            this.validateDelete(currentSnapshot, "0", null);
        } else if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "0", null, null);
        } else {
            this.validateMergeOnRead(currentSnapshot, "0", null, null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithoutCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hardware')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 4 snapshots", (long)4L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        this.validateDelete(currentSnapshot, "2", "3");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteUsingMetadataWithComplexCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'dep1')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'dep2')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'dep3')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE dep > 'dep2' OR dep = CAST(4 AS STRING) OR dep = 'dep2'", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 4 snapshots", (long)4L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        this.validateDelete(currentSnapshot, "2", "2");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "dep1"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithArbitraryPartitionPredicates() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hardware')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 10 OR dep LIKE '%%ware'", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 4 snapshots", (long)4L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "1", "1", null);
        } else {
            this.validateMergeOnRead(currentSnapshot, "1", "1", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithNonDeterministicCondition() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        AssertHelpers.assertThrows((String)"Should complain about non-deterministic expressions", AnalysisException.class, (String)"nondeterministic expressions are only allowed", () -> this.sql("DELETE FROM %s WHERE id = 1 AND rand() > 0.5", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithFoldableConditions() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE false", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE 50 <> 50", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE 1 > null", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE 21 = 21", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 2 snapshots", (long)2L, (long)Iterables.size((Iterable)table.snapshots()));
    }

    @Test
    public void testDeleteWithNullConditions() {
        this.createAndInitPartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (0, null), (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE dep = null", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE dep = 'software'", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{0, null}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE dep <=> NULL", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 3 snapshots", (long)3L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        this.validateDelete(currentSnapshot, "1", "1");
    }

    @Test
    public void testDeleteWithInAndNotInConditions() {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id IN (1, null)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id NOT IN (null, 1)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id NOT IN (1, 10)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithMultipleRowGroupsParquet() throws NoSuchTableException {
        Assume.assumeTrue((boolean)this.fileFormat.equalsIgnoreCase("parquet"));
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "write.parquet.row-group-size-bytes", 100});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%d')", new Object[]{this.tableName, "read.split.target-size", 100});
        ArrayList ids = Lists.newArrayListWithCapacity((int)200);
        for (int id = 1; id <= 200; ++id) {
            ids.add(id);
        }
        Dataset df = spark.createDataset((List)ids, Encoders.INT()).withColumnRenamed("value", "id").withColumn("dep", functions.lit((Object)"hr"));
        df.coalesce(1).writeTo(this.tableName).append();
        Assert.assertEquals((long)200L, (long)spark.table(this.tableName).count());
        this.sql("DELETE FROM %s WHERE id IN (200, 201)", new Object[]{this.tableName});
        Assert.assertEquals((long)199L, (long)spark.table(this.tableName).count());
    }

    @Test
    public void testDeleteWithConditionOnNestedColumn() {
        this.createAndInitNestedColumnsTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\"))", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2, \"c2\", \"v2\"))", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE complex.c1 = id + 2", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2})), this.sql("SELECT id FROM %s", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE t.complex.c1 = id", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT id FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.createOrReplaceView("deleted_id", Arrays.asList(0, 1, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id) AND dep IN (SELECT * from deleted_dep)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.append(new Employee(1, "hr"), new Employee(-1, "hr"));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id IS NULL OR id IN (SELECT value + 2 FROM deleted_id)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.append(new Employee(null, "hr"), new Employee(2, "hr"));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id IN (SELECT value + 2 FROM deleted_id) AND dep = 'hr'", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{-1, "hr"}), (Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithMultiColumnInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        List<Employee> deletedEmployees = Arrays.asList(new Employee(null, "hr"), new Employee(1, "hr"));
        this.createOrReplaceView("deleted_employee", deletedEmployees, Encoders.bean(Employee.class));
        this.sql("DELETE FROM %s WHERE (id, dep) IN (SELECT id, dep FROM deleted_employee)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithNotInSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr'), (2, 'hardware'), (null, 'hr')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s WHERE id NOT IN (SELECT * FROM deleted_id) OR dep IN ('software', 'hr')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL) AND EXISTS (SELECT 1 FROM FROM deleted_dep WHERE t.dep = deleted_dep.value)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE id NOT IN (SELECT * FROM deleted_id WHERE value IS NOT NULL) OR EXISTS (SELECT 1 FROM FROM deleted_dep WHERE t.dep = deleted_dep.value)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteOnNonIcebergTableNotSupported() {
        this.createOrReplaceView("testtable", "{ \"c1\": -100, \"c2\": -200 }");
        AssertHelpers.assertThrows((String)"Delete is supported only for Iceberg tables", AnalysisException.class, (String)"DELETE is only supported with v2 tables.", () -> this.sql("DELETE FROM %s WHERE c1 = -100", new Object[]{"testtable"}));
    }

    @Test
    public void testDeleteWithExistSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value) OR t.id IS NULL", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value) AND EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithNotExistsSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createOrReplaceView("deleted_id", Arrays.asList(-1, -2, null), Encoders.INT());
        this.createOrReplaceView("deleted_dep", Arrays.asList("software", "hr"), Encoders.STRING());
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (SELECT 1 FROM deleted_id di WHERE t.id = di.value + 2) AND NOT EXISTS (SELECT 1 FROM deleted_dep dd WHERE t.dep = dd.value)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2)", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        String subquery = "SELECT 1 FROM deleted_id d WHERE t.id = d.value + 2";
        this.sql("DELETE FROM %s t WHERE NOT EXISTS (%s) OR t.id = 1", new Object[]{this.tableName, subquery});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of(), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
    }

    @Test
    public void testDeleteWithScalarSubquery() throws NoSuchTableException {
        this.createAndInitUnpartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(2, "hardware"), new Employee(null, "hr"));
        this.createOrReplaceView("deleted_id", Arrays.asList(1, 100, null), Encoders.INT());
        this.withSQLConf((Map)ImmutableMap.of((Object)SQLConf.ADAPTIVE_EXECUTION_ENABLED().key(), (Object)"false"), () -> {
            this.sql("DELETE FROM %s t WHERE id <= (SELECT min(value) FROM deleted_id)", new Object[]{this.tableName});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{null, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC NULLS LAST", new Object[]{this.tableName}));
        });
    }

    @Test
    public void testDeleteThatRequiresGroupingBeforeWrite() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(new Employee(0, "ops"), new Employee(1, "ops"), new Employee(2, "ops"));
        this.append(new Employee(0, "hr"), new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(new Employee(0, "ops"), new Employee(1, "ops"), new Employee(2, "ops"));
        this.createOrReplaceView("deleted_id", Arrays.asList(1, 100), Encoders.INT());
        String originalNumOfShufflePartitions = spark.conf().get("spark.sql.shuffle.partitions");
        try {
            spark.conf().set("spark.sql.shuffle.partitions", "1");
            this.sql("DELETE FROM %s t WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.tableName});
            Assert.assertEquals((String)"Should have expected num of rows", (long)8L, (long)spark.table(this.tableName).count());
        }
        finally {
            spark.conf().set("spark.sql.shuffle.partitions", originalNumOfShufflePartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void testDeleteWithSerializableIsolation() throws InterruptedException {
        Assume.assumeFalse((boolean)this.catalogName.equalsIgnoreCase("testhadoop"));
        this.createAndInitUnpartitionedTable();
        this.createOrReplaceView("deleted_id", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.delete.isolation-level", "serializable"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> deleteFuture = executorService.submit(() -> {
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.tableName});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)table.schema());
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < Integer.MAX_VALUE; ++numOperations) {
                while (shouldAppend.get() && barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    table.newFastAppend().appendFile(dataFile).commit();
                    this.sleep(10L);
                }
                barrier.incrementAndGet();
            }
        });
        try {
            ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(deleteFuture::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(SparkException.class)).cause().isInstanceOf(ValidationException.class)).hasMessageContaining("Found conflicting files that can contain");
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        Assert.assertTrue((String)"Timeout", (boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void testDeleteWithSnapshotIsolation() throws InterruptedException, ExecutionException {
        Assume.assumeFalse((boolean)this.catalogName.equalsIgnoreCase("testhadoop"));
        this.createAndInitUnpartitionedTable();
        this.createOrReplaceView("deleted_id", Collections.singletonList(1), Encoders.INT());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", new Object[]{this.tableName, "write.delete.isolation-level", "snapshot"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", new Object[]{this.tableName});
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        AtomicBoolean shouldAppend = new AtomicBoolean(true);
        Future<?> deleteFuture = executorService.submit(() -> {
            for (int numOperations = 0; numOperations < 20; ++numOperations) {
                while (barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                this.sql("DELETE FROM %s WHERE id IN (SELECT * FROM deleted_id)", new Object[]{this.tableName});
                barrier.incrementAndGet();
            }
        });
        Future<?> appendFuture = executorService.submit(() -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            GenericRecord record = GenericRecord.create((Schema)table.schema());
            record.set(0, (Object)1);
            record.set(1, (Object)"hr");
            for (int numOperations = 0; numOperations < 20; ++numOperations) {
                while (shouldAppend.get() && barrier.get() < numOperations * 2) {
                    this.sleep(10L);
                }
                if (!shouldAppend.get()) {
                    return;
                }
                for (int numAppends = 0; numAppends < 5; ++numAppends) {
                    DataFile dataFile = this.writeDataFile(table, (List<GenericRecord>)ImmutableList.of((Object)record));
                    table.newFastAppend().appendFile(dataFile).commit();
                    this.sleep(10L);
                }
                barrier.incrementAndGet();
            }
        });
        try {
            deleteFuture.get();
        }
        finally {
            shouldAppend.set(false);
            appendFuture.cancel(true);
        }
        executorService.shutdown();
        Assert.assertTrue((String)"Timeout", (boolean)executorService.awaitTermination(2L, TimeUnit.MINUTES));
    }

    @Test
    public void testDeleteRefreshesRelationCache() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(new Employee(1, "hr"), new Employee(3, "hr"));
        this.append(new Employee(1, "hardware"), new Employee(2, "hardware"));
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have correct data", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hardware"}), (Object)this.row(new Object[]{1, "hr"})), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        this.sql("DELETE FROM %s WHERE id = 1", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 3 snapshots", (long)3L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "2", "2", "2");
        } else {
            this.validateMergeOnRead(currentSnapshot, "2", "2", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{3, "hr"})), this.sql("SELECT * FROM %s ORDER BY id, dep", new Object[]{this.tableName}));
        this.assertEquals("Should refresh the relation cache", (List)ImmutableList.of(), this.sql("SELECT * FROM tmp ORDER BY id, dep", new Object[0]));
        spark.sql("UNCACHE TABLE tmp");
    }

    @Test
    public void testDeleteWithMultipleSpecs() {
        this.createAndInitTable("id INT, dep STRING, category STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD dep", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 2, \"dep\": \"hr\", \"category\": \"c1\" }\n{ \"id\": 3, \"dep\": \"hr\", \"category\": \"c1\" }");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD category", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 5, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD category", new Object[]{this.tableName});
        this.append(this.tableName, "{ \"id\": 7, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.sql("DELETE FROM %s WHERE id IN (1, 3, 5, 7)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have 5 snapshots", (long)5L, (long)Iterables.size((Iterable)table.snapshots()));
        Snapshot currentSnapshot = table.currentSnapshot();
        if (this.mode(table) == RowLevelOperationMode.COPY_ON_WRITE) {
            this.validateCopyOnWrite(currentSnapshot, "4", "4", "1");
        } else {
            this.validateMergeOnRead(currentSnapshot, "3", "3", null);
        }
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hr", "c1"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    protected void createAndInitPartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, dep STRING) USING iceberg PARTITIONED BY (dep)", new Object[]{this.tableName});
        this.initTable();
    }

    protected void createAndInitUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, dep STRING) USING iceberg", new Object[]{this.tableName});
        this.initTable();
    }

    protected void createAndInitNestedColumnsTable() {
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", new Object[]{this.tableName});
        this.initTable();
    }

    protected void append(Employee ... employees) throws NoSuchTableException {
        List<Employee> input = Arrays.asList(employees);
        Dataset inputDF = spark.createDataFrame(input, Employee.class);
        inputDF.coalesce(1).writeTo(this.tableName).append();
    }

    private RowLevelOperationMode mode(Table table) {
        String modeName = table.properties().getOrDefault("write.delete.mode", TableProperties.DELETE_MODE_DEFAULT);
        return RowLevelOperationMode.fromName((String)modeName);
    }

    private LogicalPlan parsePlan(String query, Object ... args) {
        try {
            return spark.sessionState().sqlParser().parsePlan(String.format(query, args));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

