/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.SnapshotIdGeneratorUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestDuplicateSnapshotIDs
extends SparkExtensionsTestBase {
    public TestDuplicateSnapshotIDs(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testSameSnapshotIDBackToBack() {
        this.sql("DROP TABLE IF EXISTS %s ", new Object[]{this.tableName});
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        try (MockedStatic utilities = Mockito.mockStatic(SnapshotIdGeneratorUtil.class);){
            utilities.when(SnapshotIdGeneratorUtil::generateSnapshotID).thenReturn((Object)42L, new Object[]{42L, 43L});
            this.sql("INSERT INTO TABLE %s SELECT 1, 'a' ", new Object[]{this.tableName});
            this.sql("INSERT INTO TABLE %s SELECT 2, 'b' ", new Object[]{this.tableName});
        }
        this.sql("INSERT INTO TABLE %s SELECT 3, 'c' ", new Object[]{this.tableName});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{2L, "b"}), (Object)this.row(new Object[]{3L, "c"}));
        this.assertEquals("should have all the rows", (List)expectedRows, this.sql("SELECT * from %s order by id", new Object[]{this.tableName}));
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots", new Object[]{this.tableName}).size(), (long)3L);
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots where snapshot_id = 42L", new Object[]{this.tableName}).size(), (long)1L);
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots where snapshot_id = 43L", new Object[]{this.tableName}).size(), (long)1L);
    }

    @Test
    public void testSameSnapshotID() {
        this.sql("DROP TABLE IF EXISTS %s ", new Object[]{this.tableName});
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        try (MockedStatic utilities = Mockito.mockStatic(SnapshotIdGeneratorUtil.class);){
            utilities.when(SnapshotIdGeneratorUtil::generateSnapshotID).thenReturn((Object)42L);
            this.sql("INSERT INTO TABLE %s SELECT 1, 'a' ", new Object[]{this.tableName});
        }
        this.sql("INSERT INTO TABLE %s SELECT 2, 'b' ", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s SELECT 3, 'c' ", new Object[]{this.tableName});
        utilities = Mockito.mockStatic(SnapshotIdGeneratorUtil.class);
        var2_2 = null;
        try {
            utilities.when(SnapshotIdGeneratorUtil::generateSnapshotID).thenReturn((Object)42L, new Object[]{43L});
            this.sql("INSERT INTO TABLE %s SELECT 4, 'd' ", new Object[]{this.tableName});
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (utilities != null) {
                TestDuplicateSnapshotIDs.$closeResource(var2_2, (AutoCloseable)utilities);
            }
        }
        this.sql("INSERT INTO TABLE %s SELECT 5, 'e' ", new Object[]{this.tableName});
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{2L, "b"}), (Object)this.row(new Object[]{3L, "c"}), (Object)this.row(new Object[]{4L, "d"}), (Object)this.row(new Object[]{5L, "e"}));
        this.assertEquals("should have all the rows", (List)expectedRows, this.sql("SELECT * from %s order by id", new Object[]{this.tableName}));
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots", new Object[]{this.tableName}).size(), (long)5L);
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots where snapshot_id = 42L", new Object[]{this.tableName}).size(), (long)1L);
        Assert.assertEquals((long)this.sql("SELECT * from %s.snapshots where snapshot_id = 43L", new Object[]{this.tableName}).size(), (long)1L);
    }
}

