/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.junit.After;
import org.junit.Test;

public class TestIcebergExpressions
extends SparkExtensionsTestBase {
    public TestIcebergExpressions(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP VIEW IF EXISTS emp", new Object[0]);
        this.sql("DROP VIEW IF EXISTS v", new Object[0]);
    }

    @Test
    public void testTruncateExpressions() {
        this.sql("CREATE TABLE %s (   int_c INT, long_c LONG, dec_c DECIMAL(4, 2), str_c STRING, binary_c BINARY ) USING iceberg", new Object[]{this.tableName});
        this.sql("CREATE TEMPORARY VIEW emp AS SELECT * FROM VALUES (101, 10001, 10.65, '101-Employee', CAST('1234' AS BINARY)) AS EMP(int_c, long_c, dec_c, str_c, binary_c)", new Object[0]);
        this.sql("INSERT INTO %s SELECT * FROM emp", new Object[]{this.tableName});
        Dataset df = spark.sql("SELECT * FROM " + this.tableName);
        df.select(new Column[]{new Column((Expression)new IcebergTruncateTransform(df.col("int_c").expr(), 2)).as("int_c"), new Column((Expression)new IcebergTruncateTransform(df.col("long_c").expr(), 2)).as("long_c"), new Column((Expression)new IcebergTruncateTransform(df.col("dec_c").expr(), 50)).as("dec_c"), new Column((Expression)new IcebergTruncateTransform(df.col("str_c").expr(), 2)).as("str_c"), new Column((Expression)new IcebergTruncateTransform(df.col("binary_c").expr(), 2)).as("binary_c")}).createOrReplaceTempView("v");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{100, 10000L, new BigDecimal("10.50"), "10", "12"})), this.sql("SELECT int_c, long_c, dec_c, str_c, CAST(binary_c AS STRING) FROM v", new Object[0]));
    }
}

