/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.extensions.TestDelete;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.spark.source.TestSparkCatalog;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

public class TestMergeOnReadDelete
extends TestDelete {
    public TestMergeOnReadDelete(String catalogName, String implementation, Map<String, String> config, String fileFormat, Boolean vectorized, String distributionMode) {
        super(catalogName, implementation, config, fileFormat, vectorized, distributionMode);
    }

    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"write.delete.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @Parameterized.AfterParam
    public static void clearTestSparkCatalogCache() {
        TestSparkCatalog.clearTables();
    }

    @Test
    public void testCommitUnknownException() {
        this.createAndInitTable("id INT, dep STRING, category STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.append(this.tableName, "{ \"id\": 2, \"dep\": \"hr\", \"category\": \"c1\" }\n{ \"id\": 3, \"dep\": \"hr\", \"category\": \"c1\" }");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        RowDelta newRowDelta = table.newRowDelta();
        RowDelta spyNewRowDelta = (RowDelta)Mockito.spy((Object)newRowDelta);
        ((RowDelta)Mockito.doAnswer(invocation -> {
            newRowDelta.commit();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Datacenter on Fire"));
        }).when((Object)spyNewRowDelta)).commit();
        Table spyTable = (Table)Mockito.spy((Object)table);
        Mockito.when((Object)spyTable.newRowDelta()).thenReturn((Object)spyNewRowDelta);
        SparkTable sparkTable = new SparkTable(spyTable, false);
        ImmutableMap config = ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default");
        spark.conf().set("spark.sql.catalog.dummy_catalog", "org.apache.iceberg.spark.source.TestSparkCatalog");
        config.forEach((key, value) -> spark.conf().set("spark.sql.catalog.dummy_catalog." + key, value));
        Identifier ident = Identifier.of((String[])new String[]{"default"}, (String)"table");
        TestSparkCatalog.setTable((Identifier)ident, (org.apache.spark.sql.connector.catalog.Table)sparkTable);
        AssertHelpers.assertThrowsWithCause((String)"Should throw a Commit State Unknown Exception", SparkException.class, (String)"Writing job aborted", CommitStateUnknownException.class, (String)"Datacenter on Fire", () -> this.sql("DELETE FROM %s WHERE id = 2", new Object[]{"dummy_catalog.default.table"}));
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr", "c1"}), (Object)this.row(new Object[]{3, "hr", "c1"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"dummy_catalog.default.table"}));
    }
}

