/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.junit.After;
import org.junit.Test;

public class TestPublishChangesProcedure
extends SparkExtensionsTestBase {
    public TestPublishChangesProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testApplyWapChangesUsingPositionalArgs() {
        String wapId = "wap_id_1";
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", wapId);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.publish_changes('%s', '%s')", new Object[]{this.catalogName, this.tableIdent, wapId});
        table.refresh();
        Snapshot currentSnapshot = table.currentSnapshot();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{wapSnapshot.snapshotId(), currentSnapshot.snapshotId()})), output);
        this.assertEquals("Apply of WAP changes must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testApplyWapChangesUsingNamedArgs() {
        String wapId = "wap_id_1";
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", wapId);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.publish_changes(wap_id => '%s', table => '%s')", new Object[]{this.catalogName, wapId, this.tableIdent});
        table.refresh();
        Snapshot currentSnapshot = table.currentSnapshot();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{wapSnapshot.snapshotId(), currentSnapshot.snapshotId()})), output);
        this.assertEquals("Apply of WAP changes must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testApplyWapChangesRefreshesRelationCache() {
        String wapId = "wap_id_1";
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should not produce rows", (List)ImmutableList.of(), this.sql("SELECT * FROM tmp", new Object[0]));
        spark.conf().set("spark.wap.id", wapId);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        this.sql("CALL %s.system.publish_changes('%s', '%s')", new Object[]{this.catalogName, this.tableIdent, wapId});
        this.assertEquals("Apply of WAP changes should be visible", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("UNCACHE TABLE tmp", new Object[0]);
    }

    @Test
    public void testApplyInvalidWapId() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        AssertHelpers.assertThrows((String)"Should reject invalid wap id", ValidationException.class, (String)"Cannot apply unknown WAP ID", () -> this.sql("CALL %s.system.publish_changes('%s', 'not_valid')", new Object[]{this.catalogName, this.tableIdent}));
    }

    @Test
    public void testInvalidApplyWapChangesCases() {
        AssertHelpers.assertThrows((String)"Should not allow mixed args", AnalysisException.class, (String)"Named and positional arguments cannot be mixed", () -> this.sql("CALL %s.system.publish_changes('n', table => 't', 'not_valid')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should not resolve procedures in arbitrary namespaces", NoSuchProcedureException.class, (String)"not found", () -> this.sql("CALL %s.custom.publish_changes('n', 't', 'not_valid')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.publish_changes('t')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.publish_changes('', 'not_valid')", new Object[]{this.catalogName}));
    }
}

