/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.junit.After;
import org.junit.Test;

public class TestRequiredDistributionAndOrdering
extends SparkExtensionsTestBase {
    public TestRequiredDistributionAndOrdering(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void dropTestTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testDefaultLocalSortWithBucketTransforms() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List)ImmutableList.of((Object)this.row(new Object[]{7L})), this.sql("SELECT count(*) FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testPartitionColumnsArePrependedForRangeDistribution() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        this.sql("ALTER TABLE %s WRITE ORDERED BY c1, c2", new Object[]{this.tableName});
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List)ImmutableList.of((Object)this.row(new Object[]{7L})), this.sql("SELECT count(*) FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testSortOrderIncludesPartitionColumns() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        this.sql("ALTER TABLE %s WRITE ORDERED BY bucket(2, c3), c1, c2", new Object[]{this.tableName});
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List)ImmutableList.of((Object)this.row(new Object[]{7L})), this.sql("SELECT count(*) FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testHashDistributionOnBucketedColumn() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION ORDERED BY c1, c2", new Object[]{this.tableName});
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List)ImmutableList.of((Object)this.row(new Object[]{7L})), this.sql("SELECT count(*) FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testDisabledDistributionAndOrdering() {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        AssertHelpers.assertThrows((String)"Should reject writes without ordering", SparkException.class, (String)"Writing job aborted", () -> {
            try {
                inputDF.writeTo(this.tableName).option("use-table-distribution-and-ordering", "false").append();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testDefaultSortOnDecimalBucketedColumn() {
        this.sql("CREATE TABLE %s (c1 INT, c2 DECIMAL(20, 2)) USING iceberg PARTITIONED BY (bucket(2, c2))", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 20.2), (2, 40.2), (3, 60.2)", new Object[]{this.tableName});
        ImmutableList expected = ImmutableList.of((Object)this.row(new Object[]{1, new BigDecimal("20.20")}), (Object)this.row(new Object[]{2, new BigDecimal("40.20")}), (Object)this.row(new Object[]{3, new BigDecimal("60.20")}));
        this.assertEquals("Rows must match", (List)expected, this.sql("SELECT * FROM %s ORDER BY c1", new Object[]{this.tableName}));
    }

    @Test
    public void testDefaultSortOnStringBucketedColumn() {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING) USING iceberg PARTITIONED BY (bucket(2, c2))", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 'A'), (2, 'B')", new Object[]{this.tableName});
        ImmutableList expected = ImmutableList.of((Object)this.row(new Object[]{1, "A"}), (Object)this.row(new Object[]{2, "B"}));
        this.assertEquals("Rows must match", (List)expected, this.sql("SELECT * FROM %s ORDER BY c1", new Object[]{this.tableName}));
    }

    @Test
    public void testDefaultSortOnDecimalTruncatedColumn() {
        this.sql("CREATE TABLE %s (c1 INT, c2 DECIMAL(20, 2)) USING iceberg PARTITIONED BY (truncate(2, c2))", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 20.2), (2, 40.2)", new Object[]{this.tableName});
        ImmutableList expected = ImmutableList.of((Object)this.row(new Object[]{1, new BigDecimal("20.20")}), (Object)this.row(new Object[]{2, new BigDecimal("40.20")}));
        this.assertEquals("Rows must match", (List)expected, this.sql("SELECT * FROM %s ORDER BY c1", new Object[]{this.tableName}));
    }

    @Test
    public void testDefaultSortOnLongTruncatedColumn() {
        this.sql("CREATE TABLE %s (c1 INT, c2 BIGINT) USING iceberg PARTITIONED BY (truncate(2, c2))", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 22222222222222), (2, 444444444444)", new Object[]{this.tableName});
        ImmutableList expected = ImmutableList.of((Object)this.row(new Object[]{1, 22222222222222L}), (Object)this.row(new Object[]{2, 444444444444L}));
        this.assertEquals("Rows must match", (List)expected, this.sql("SELECT * FROM %s ORDER BY c1", new Object[]{this.tableName}));
    }

    @Test
    public void testRangeDistributionWithQuotedColumnNames() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (`c.1` INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, `c.1`))", new Object[]{this.tableName});
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(Integer.valueOf(1), null, "A"), (Object)new ThreeColumnRecord(Integer.valueOf(2), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(3), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(4), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(5), "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(Integer.valueOf(6), "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(Integer.valueOf(7), "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.selectExpr(new String[]{"c1 as `c.1`", "c2", "c3"}).coalesce(1).sortWithinPartitions("`c.1`", new String[0]);
        this.sql("ALTER TABLE %s WRITE ORDERED BY `c.1`, c2", new Object[]{this.tableName});
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List)ImmutableList.of((Object)this.row(new Object[]{7L})), this.sql("SELECT count(*) FROM %s", new Object[]{this.tableName}));
    }
}

