/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Map;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSetWriteDistributionAndOrdering
extends SparkExtensionsTestBase {
    public TestSetWriteDistributionAndOrdering(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testSetWriteOrderByColumn() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY category, id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"range", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_FIRST)).asc("id", NullOrder.NULLS_FIRST)).build();
        Assert.assertEquals((String)"Should have expected order", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteOrderByColumnWithDirection() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY category ASC, id DESC", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"range", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_FIRST)).desc("id", NullOrder.NULLS_LAST)).build();
        Assert.assertEquals((String)"Should have expected order", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteOrderByColumnWithDirectionAndNullOrder() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY category ASC NULLS LAST, id DESC NULLS FIRST", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"range", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("category", NullOrder.NULLS_LAST)).desc("id", NullOrder.NULLS_FIRST)).build();
        Assert.assertEquals((String)"Should have expected order", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteOrderByTransform() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"range", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).desc("category")).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
        Assert.assertEquals((String)"Should have expected order", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteUnordered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"range", (Object)distributionMode);
        Assert.assertNotEquals((String)"Table must be sorted", (Object)SortOrder.unsorted(), (Object)table.sortOrder());
        this.sql("ALTER TABLE %s WRITE UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String newDistributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"New distribution mode must match", (Object)"none", (Object)newDistributionMode);
        Assert.assertEquals((String)"New sort order must match", (Object)SortOrder.unsorted(), (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteLocallyOrdered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string, ts timestamp, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE LOCALLY ORDERED BY category DESC, bucket(16, id), id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"none", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).desc("category")).asc((Term)Expressions.bucket((String)"id", (int)16))).asc("id")).build();
        Assert.assertEquals((String)"Sort order must match", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedByWithSort() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION ORDERED BY id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        Assert.assertEquals((String)"Sort order must match", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedByWithLocalSort() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION LOCALLY ORDERED BY id", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        Assert.assertEquals((String)"Sort order must match", (Object)expected, (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedByAndUnordered() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        Assert.assertEquals((String)"Sort order must match", (Object)SortOrder.unsorted(), (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedByOnly() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE DISTRIBUTED BY PARTITION UNORDERED", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        Assert.assertEquals((String)"Sort order must match", (Object)SortOrder.unsorted(), (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedAndUnorderedInverted() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE UNORDERED DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        Assert.assertEquals((String)"Sort order must match", (Object)SortOrder.unsorted(), (Object)table.sortOrder());
    }

    @Test
    public void testSetWriteDistributedAndLocallyOrderedInverted() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, category string) USING iceberg PARTITIONED BY (category)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unsorted", (boolean)table.sortOrder().isUnsorted());
        this.sql("ALTER TABLE %s WRITE ORDERED BY id DISTRIBUTED BY PARTITION", new Object[]{this.tableName});
        table.refresh();
        String distributionMode = (String)table.properties().get("write.distribution-mode");
        Assert.assertEquals((String)"Distribution mode must match", (Object)"hash", (Object)distributionMode);
        SortOrder expected = ((SortOrder.Builder)SortOrder.builderFor((Schema)table.schema()).withOrderId(1).asc("id")).build();
        Assert.assertEquals((String)"Sort order must match", (Object)expected, (Object)table.sortOrder());
    }
}

