/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSnapshotTableProcedure
extends SparkExtensionsTestBase {
    private static final String sourceName = "spark_catalog.default.source";
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    public TestSnapshotTableProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %S", new Object[]{sourceName});
    }

    @Test
    public void testSnapshot() throws IOException {
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{sourceName});
        Object result = this.scalarSql("CALL %s.system.snapshot('%s', '%s')", new Object[]{this.catalogName, sourceName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location();
        Assert.assertNotEquals((String)"Table should not have the original location", (Object)location, (Object)tableLocation);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testSnapshotWithProperties() throws IOException {
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{sourceName});
        Object result = this.scalarSql("CALL %s.system.snapshot(source_table => '%s', table => '%s', properties => map('foo','bar'))", new Object[]{this.catalogName, sourceName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location();
        Assert.assertNotEquals((String)"Table should not have the original location", (Object)location, (Object)tableLocation);
        Map props = createdTable.properties();
        Assert.assertEquals((String)"Should have extra property set", (Object)"bar", props.get("foo"));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testSnapshotWithAlternateLocation() throws IOException {
        Assume.assumeTrue((String)"No Snapshoting with Alternate locations with Hadoop Catalogs", (!this.catalogName.contains("hadoop") ? 1 : 0) != 0);
        String location = this.temp.newFolder().toString();
        String snapshotLocation = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{sourceName});
        Object[] result = (Object[])this.sql("CALL %s.system.snapshot(source_table => '%s', table => '%s', location => '%s')", new Object[]{this.catalogName, sourceName, this.tableName, snapshotLocation}).get(0);
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result[0]);
        String storageLocation = this.validationCatalog.loadTable(this.tableIdent).location();
        Assert.assertEquals((String)"Snapshot should be made at specified location", (Object)snapshotLocation, (Object)storageLocation);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testDropTable() throws IOException {
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{sourceName});
        Object result = this.scalarSql("CALL %s.system.snapshot('%s', '%s')", new Object[]{this.catalogName, sourceName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        this.sql("DROP TABLE %s", new Object[]{this.tableName});
        this.assertEquals("Source table should be intact", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{sourceName}));
    }

    @Test
    public void testSnapshotWithConflictingProps() throws IOException {
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{sourceName});
        Object result = this.scalarSql("CALL %s.system.snapshot(source_table => '%s',table => '%s',properties => map('%s', 'true', 'snapshot', 'false'))", new Object[]{this.catalogName, sourceName, this.tableName, "gc.enabled"});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Map props = table.properties();
        Assert.assertEquals((String)"Should override user value", (Object)"true", props.get("snapshot"));
        Assert.assertEquals((String)"Should override user value", (Object)"false", props.get("gc.enabled"));
    }

    @Test
    public void testInvalidSnapshotsCases() throws IOException {
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{sourceName, location});
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.snapshot('foo')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid arg types", AnalysisException.class, (String)"Wrong arg type", () -> this.sql("CALL %s.system.snapshot('n', 't', map('foo', 'bar'))", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid map args", AnalysisException.class, (String)"cannot resolve 'map", () -> this.sql("CALL %s.system.snapshot('%s', 'fable', 'loc', map(2, 1, 1))", new Object[]{this.catalogName, sourceName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.snapshot('', 'dest')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.snapshot('src', '')", new Object[]{this.catalogName}));
    }
}

