/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IcebergBucketTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergDayTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergHourTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergMonthTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergYearTransform;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.expressions.BucketTransform$;
import org.apache.spark.sql.connector.expressions.DaysTransform$;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform$;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.MonthsTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortValue$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.TruncateTransform$;
import org.apache.spark.sql.connector.expressions.YearsTransform$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class ExtendedV2ExpressionUtils$
implements SQLConfHelper {
    public static ExtendedV2ExpressionUtils$ MODULE$;

    static {
        new ExtendedV2ExpressionUtils$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T extends NamedExpression> T resolveRef(NamedReference ref, LogicalPlan plan) {
        NamedExpression namedExpr;
        Option option = plan.resolve(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames())).toSeq(), this.conf().resolver());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String name = CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames())).toSeq()).quoted();
                String outputString = ((TraversableOnce)plan.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(",");
                throw QueryCompilationErrors$.MODULE$.cannotResolveAttributeError(name, outputString);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        NamedExpression namedExpression = namedExpr = (NamedExpression)some.value();
        return (T)namedExpression;
    }

    public <T extends NamedExpression> Seq<T> resolveRefs(Seq<NamedReference> refs, LogicalPlan plan) {
        return (Seq)refs.map((Function1 & Serializable & scala.Serializable)ref -> MODULE$.resolveRef((NamedReference)ref, plan), Seq$.MODULE$.canBuildFrom());
    }

    public Expression toCatalyst(org.apache.spark.sql.connector.expressions.Expression expr, LogicalPlan query) {
        Expression expression;
        org.apache.spark.sql.connector.expressions.Expression expression2 = expr;
        Option option = SortValue$.MODULE$.unapply(expression2);
        if (!option.isEmpty()) {
            org.apache.spark.sql.connector.expressions.Expression child = (org.apache.spark.sql.connector.expressions.Expression)((Tuple3)option.get())._1();
            org.apache.spark.sql.connector.expressions.SortDirection direction = (org.apache.spark.sql.connector.expressions.SortDirection)((Tuple3)option.get())._2();
            org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering = (org.apache.spark.sql.connector.expressions.NullOrdering)((Tuple3)option.get())._3();
            Expression catalystChild = this.toCatalyst(child, query);
            expression = new SortOrder(catalystChild, this.toCatalyst(direction), this.toCatalyst(nullOrdering), (Seq)Nil$.MODULE$);
        } else {
            Transform transform;
            Option option2 = IdentityTransform$.MODULE$.unapply(expression2);
            if (!option2.isEmpty()) {
                FieldReference ref = (FieldReference)option2.get();
                expression = (Expression)this.resolveRef((NamedReference)ref, query);
            } else if (expression2 instanceof Transform && BucketTransform$.MODULE$.unapply(transform = (Transform)expression2).isDefined()) {
                Expression expression3;
                Transform transform2 = transform;
                Option option3 = BucketTransform$.MODULE$.unapply(transform2);
                if (!option3.isEmpty()) {
                    int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option3.get())._1());
                    Seq cols = (Seq)((Tuple3)option3.get())._2();
                    expression3 = new IcebergBucketTransform(numBuckets, (Expression)this.resolveRef((NamedReference)cols.head(), query));
                } else {
                    expression3 = (Expression)transform;
                }
                expression = expression3;
            } else {
                Option<Tuple2<Object, FieldReference>> option4 = TruncateTransform$.MODULE$.unapply(expression2);
                if (!option4.isEmpty()) {
                    int length = ((Tuple2)option4.get())._1$mcI$sp();
                    FieldReference ref = (FieldReference)((Tuple2)option4.get())._2();
                    expression = new IcebergTruncateTransform((Expression)this.resolveRef((NamedReference)ref, query), length);
                } else {
                    Option option5 = YearsTransform$.MODULE$.unapply(expression2);
                    if (!option5.isEmpty()) {
                        FieldReference ref = (FieldReference)option5.get();
                        expression = new IcebergYearTransform((Expression)this.resolveRef((NamedReference)ref, query));
                    } else {
                        Option option6 = MonthsTransform$.MODULE$.unapply(expression2);
                        if (!option6.isEmpty()) {
                            FieldReference ref = (FieldReference)option6.get();
                            expression = new IcebergMonthTransform((Expression)this.resolveRef((NamedReference)ref, query));
                        } else {
                            Option option7 = DaysTransform$.MODULE$.unapply(expression2);
                            if (!option7.isEmpty()) {
                                FieldReference ref = (FieldReference)option7.get();
                                expression = new IcebergDayTransform((Expression)this.resolveRef((NamedReference)ref, query));
                            } else {
                                Option option8 = HoursTransform$.MODULE$.unapply(expression2);
                                if (!option8.isEmpty()) {
                                    FieldReference ref = (FieldReference)option8.get();
                                    expression = new IcebergHourTransform((Expression)this.resolveRef((NamedReference)ref, query));
                                } else if (expression2 instanceof FieldReference) {
                                    FieldReference fieldReference = (FieldReference)expression2;
                                    expression = (Expression)this.resolveRef((NamedReference)fieldReference, query);
                                } else {
                                    throw new AnalysisException(new StringBuilder(27).append(expr).append(" is not currently supported").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                                }
                            }
                        }
                    }
                }
            }
        }
        return expression;
    }

    private SortDirection toCatalyst(org.apache.spark.sql.connector.expressions.SortDirection direction) {
        Ascending$ ascending$;
        org.apache.spark.sql.connector.expressions.SortDirection sortDirection = direction;
        if (org.apache.spark.sql.connector.expressions.SortDirection.ASCENDING.equals(sortDirection)) {
            ascending$ = Ascending$.MODULE$;
        } else if (org.apache.spark.sql.connector.expressions.SortDirection.DESCENDING.equals(sortDirection)) {
            ascending$ = Descending$.MODULE$;
        } else {
            throw new MatchError((Object)sortDirection);
        }
        return ascending$;
    }

    private NullOrdering toCatalyst(org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering) {
        NullsFirst$ nullsFirst$;
        org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering2 = nullOrdering;
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
            nullsFirst$ = NullsFirst$.MODULE$;
        } else if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_LAST.equals(nullOrdering2)) {
            nullsFirst$ = NullsLast$.MODULE$;
        } else {
            throw new MatchError((Object)nullOrdering2);
        }
        return nullsFirst$;
    }

    private ExtendedV2ExpressionUtils$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

