/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestAlterTablePartitionFields
extends SparkExtensionsTestBase {
    private final int formatVersion;

    @Parameterized.Parameters(name="catalogConfig = {0}, formatVersion = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE, 1}, {SparkCatalogConfig.SPARK, 2}};
    }

    public TestAlterTablePartitionFields(SparkCatalogConfig catalogConfig, int formatVersion) {
        super(catalogConfig.catalogName(), catalogConfig.implementation(), catalogConfig.properties());
        this.formatVersion = formatVersion;
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testAddIdentityPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD category", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).identity("category").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddBucketPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).bucket("id", 16, "id_bucket_16").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddTruncatePartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD truncate(data, 4)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).truncate("data", 4, "data_trunc_4").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddYearsPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD years(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).year("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddMonthsPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD months(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).month("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddDaysPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddHoursPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD hours(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).hour("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testAddYearPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD year(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).year("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testAddMonthPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD month(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).month("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testAddDayPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD day(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testAddHourPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table should start unpartitioned", new Object[0])).isTrue();
        this.sql("ALTER TABLE %s ADD PARTITION FIELD hour(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).hour("ts").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should have new spec field", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testAddNamedPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).bucket("id", 16, "shard").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testDropIdentityPartition() {
        this.createTable("id bigint NOT NULL, category string, data string", "category");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Table should start with 1 partition field", (long)1L, (long)table.spec().fields().size());
        this.sql("ALTER TABLE %s DROP PARTITION FIELD category", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("category", "category").build();
            Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        } else {
            Assert.assertTrue((String)"New spec must be unpartitioned", (boolean)table.spec().isUnpartitioned());
        }
    }

    @Test
    public void testDropDaysPartition() {
        this.createTable("id bigint NOT NULL, ts timestamp, data string", "days(ts)");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Table should start with 1 partition field", (long)1L, (long)table.spec().fields().size());
        this.sql("ALTER TABLE %s DROP PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("ts", "ts_day").build();
            Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        } else {
            Assert.assertTrue((String)"New spec must be unpartitioned", (boolean)table.spec().isUnpartitioned());
        }
    }

    @Test
    public void testDropBucketPartition() {
        this.createTable("id bigint NOT NULL, data string", "bucket(16, id)");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Table should start with 1 partition field", (long)1L, (long)table.spec().fields().size());
        this.sql("ALTER TABLE %s DROP PARTITION FIELD bucket(16, id)", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).alwaysNull("id", "id_bucket").build();
            Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        } else {
            Assert.assertTrue((String)"New spec must be unpartitioned", (boolean)table.spec().isUnpartitioned());
        }
    }

    @Test
    public void testDropPartitionByName() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Table should have 1 partition field", (long)1L, (long)table.spec().fields().size());
        this.sql("ALTER TABLE %s DROP  PARTITION \n FIELD shard", new Object[]{this.tableName});
        table.refresh();
        if (this.formatVersion == 1) {
            PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("id", "shard").build();
            Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        } else {
            Assert.assertTrue((String)"New spec must be unpartitioned", (boolean)table.spec().isUnpartitioned());
        }
    }

    @Test
    public void testReplacePartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD days(ts) WITH hours(ts)", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "ts_day").hour("ts").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "ts_hour").build();
        Assert.assertEquals((String)"Should changed from daily to hourly partitioned field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testReplacePartitionAndRename() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts)", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD days(ts) WITH hours(ts) AS hour_col", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "ts_day").hour("ts", "hour_col").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "hour_col").build();
        Assert.assertEquals((String)"Should changed from daily to hourly partitioned field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testReplaceNamedPartition() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts) AS day_col", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts", "day_col").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_col WITH hours(ts)", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "day_col").hour("ts").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "ts_hour").build();
        Assert.assertEquals((String)"Should changed from daily to hourly partitioned field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testReplaceNamedPartitionAndRenameDifferently() {
        this.createTable("id bigint NOT NULL, category string, ts timestamp, data string");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start unpartitioned", (boolean)table.spec().isUnpartitioned());
        this.sql("ALTER TABLE %s ADD PARTITION FIELD days(ts) AS day_col", new Object[]{this.tableName});
        table.refresh();
        PartitionSpec expected = PartitionSpec.builderFor((Schema)table.schema()).withSpecId(1).day("ts", "day_col").build();
        Assert.assertEquals((String)"Should have new spec field", (Object)expected, (Object)table.spec());
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_col WITH hours(ts) AS hour_col", new Object[]{this.tableName});
        table.refresh();
        expected = this.formatVersion == 1 ? PartitionSpec.builderFor((Schema)table.schema()).withSpecId(2).alwaysNull("ts", "day_col").hour("ts", "hour_col").build() : TestHelpers.newExpectedSpecBuilder().withSchema(table.schema()).withSpecId(2).addField("hour", 3, 1001, "hour_col").build();
        Assert.assertEquals((String)"Should changed from daily to hourly partitioned field", (Object)expected, (Object)table.spec());
    }

    @Test
    public void testSparkTableAddDropPartitions() throws Exception {
        this.createTable("id bigint NOT NULL, ts timestamp, data string");
        Assert.assertEquals((String)"spark table partition should be empty", (long)0L, (long)this.sparkTable().partitioning().length);
        this.sql("ALTER TABLE %s ADD PARTITION FIELD bucket(16, id) AS shard", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 1, "bucket(16, id)");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD truncate(data, 4)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 2, "truncate(4, data)");
        this.sql("ALTER TABLE %s ADD PARTITION FIELD years(ts)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 3, "years(ts)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD years(ts)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 2, "truncate(4, data)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD truncate(4, data)", new Object[]{this.tableName});
        this.assertPartitioningEquals(this.sparkTable(), 1, "bucket(16, id)");
        this.sql("ALTER TABLE %s DROP PARTITION FIELD shard", new Object[]{this.tableName});
        this.sql("DESCRIBE %s", new Object[]{this.tableName});
        Assert.assertEquals((String)"spark table partition should be empty", (long)0L, (long)this.sparkTable().partitioning().length);
    }

    @Test
    public void testDropColumnOfOldPartitionFieldV1() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, ts timestamp, day_of_ts date) USING iceberg PARTITIONED BY (day_of_ts) TBLPROPERTIES('format-version' = '1')", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_of_ts WITH days(ts)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s DROP COLUMN day_of_ts", new Object[]{this.tableName});
    }

    @Test
    public void testDropColumnOfOldPartitionFieldV2() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, ts timestamp, day_of_ts date) USING iceberg PARTITIONED BY (day_of_ts) TBLPROPERTIES('format-version' = '2')", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_of_ts WITH days(ts)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s DROP COLUMN day_of_ts", new Object[]{this.tableName});
    }

    private void assertPartitioningEquals(SparkTable table, int len, String transform) {
        Assert.assertEquals((String)("spark table partition should be " + len), (long)len, (long)table.partitioning().length);
        Assert.assertEquals((String)"latest spark table partition transform should match", (Object)transform, (Object)table.partitioning()[len - 1].toString());
    }

    private SparkTable sparkTable() throws Exception {
        this.validationCatalog.loadTable(this.tableIdent).refresh();
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        TableCatalog catalog = (TableCatalog)catalogManager.catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        return (SparkTable)catalog.loadTable(identifier);
    }

    private void createTable(String schema) {
        this.createTable(schema, null);
    }

    private void createTable(String schema, String spec) {
        if (spec == null) {
            this.sql("CREATE TABLE %s (%s) USING iceberg TBLPROPERTIES ('%s' '%d')", new Object[]{this.tableName, schema, "format-version", this.formatVersion});
        } else {
            this.sql("CREATE TABLE %s (%s) USING iceberg PARTITIONED BY (%s) TBLPROPERTIES ('%s' '%d')", new Object[]{this.tableName, schema, spec, "format-version", this.formatVersion});
        }
    }
}

