/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateChangelogViewProcedure
extends SparkExtensionsTestBase {
    private static final String DELETE = ChangelogOperation.DELETE.name();
    private static final String INSERT = ChangelogOperation.INSERT.name();
    private static final String UPDATE_BEFORE = ChangelogOperation.UPDATE_BEFORE.name();
    private static final String UPDATE_AFTER = ChangelogOperation.UPDATE_AFTER.name();

    public TestCreateChangelogViewProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    public void createTableWithTwoColumns() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s ADD PARTITION FIELD data", new Object[]{this.tableName});
    }

    private void createTableWithThreeColumns() {
        this.sql("CREATE TABLE %s (id INT, data STRING, age INT) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s ADD PARTITION FIELD id", new Object[]{this.tableName});
    }

    private void createTableWithIdentifierField() {
        this.sql("CREATE TABLE %s (id INT NOT NULL, data STRING) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id", new Object[]{this.tableName});
    }

    @Test
    public void testCustomizedViewName() {
        this.createTableWithTwoColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        this.sql("CALL %s.system.create_changelog_view(table => '%s',options => map('%s','%s','%s','%s'),changelog_view => '%s')", new Object[]{this.catalogName, this.tableName, "start-snapshot-id", snap1.snapshotId(), "end-snapshot-id", snap2.snapshotId(), "cdc_view"});
        long rowCount = this.sql("select * from %s", new Object[]{"cdc_view"}).stream().count();
        Assert.assertEquals((long)2L, (long)rowCount);
    }

    @Test
    public void testNoSnapshotIdInput() {
        this.createTableWithTwoColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap0 = table.currentSnapshot();
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s')", new Object[]{this.catalogName, this.tableName, "cdc_view"});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", INSERT, 0, snap0.snapshotId()}), (Object)this.row(new Object[]{2, "b", INSERT, 1, snap1.snapshotId()}), (Object)this.row(new Object[]{-2, "b", INSERT, 2, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "b", DELETE, 2, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id", new Object[]{viewName}));
    }

    @Test
    public void testTimestampsBasedQuery() {
        this.createTableWithTwoColumns();
        long beginning = System.currentTimeMillis();
        this.sql("INSERT INTO %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap0 = table.currentSnapshot();
        long afterFirstInsert = this.waitUntilAfter(snap0.timestampMillis());
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (-2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        long afterInsertOverwrite = this.waitUntilAfter(snap2.timestampMillis());
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', options => map('%s', '%s','%s', '%s'))", new Object[]{this.catalogName, this.tableName, "start-timestamp", beginning, "end-timestamp", afterInsertOverwrite});
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", INSERT, 0, snap0.snapshotId()}), (Object)this.row(new Object[]{2, "b", INSERT, 1, snap1.snapshotId()}), (Object)this.row(new Object[]{-2, "b", INSERT, 2, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "b", DELETE, 2, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id", new Object[]{((Object[])returns.get(0))[0]}));
        returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', options => map('%s', '%s', '%s', '%s'))", new Object[]{this.catalogName, this.tableName, "start-timestamp", afterFirstInsert, "end-timestamp", afterInsertOverwrite});
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{-2, "b", INSERT, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "b", DELETE, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id", new Object[]{((Object[])returns.get(0))[0]}));
    }

    @Test
    public void testUpdate() {
        this.createTableWithTwoColumns();
        this.sql("ALTER TABLE %s DROP PARTITION FIELD data", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s ADD PARTITION FIELD id", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c'), (2, 'd')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', identifier_columns => array('id'))", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", UPDATE_BEFORE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", UPDATE_AFTER, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", INSERT, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testUpdateWithIdentifierField() {
        this.createTableWithIdentifierField();
        this.sql("INSERT INTO %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c'), (2, 'd')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', compute_updates => true)", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", UPDATE_BEFORE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", UPDATE_AFTER, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", INSERT, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testUpdateWithFilter() {
        this.createTableWithTwoColumns();
        this.sql("ALTER TABLE %s DROP PARTITION FIELD data", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s ADD PARTITION FIELD id", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c'), (2, 'd')", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', identifier_columns => array('id'))", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", UPDATE_BEFORE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", UPDATE_AFTER, 1, snap2.snapshotId()})), this.sql("select * from %s where id != 3 order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testUpdateWithMultipleIdentifierColumns() {
        this.createTableWithThreeColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a', 12), (2, 'b', 11)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c', 13), (2, 'd', 11), (2, 'e', 12)", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(identifier_columns => array('id','age'),table => '%s')", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, UPDATE_BEFORE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", 11, UPDATE_AFTER, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "e", 12, INSERT, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", 13, INSERT, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testRemoveCarryOvers() {
        this.createTableWithThreeColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a', 12), (2, 'b', 11), (2, 'e', 12)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c', 13), (2, 'd', 11), (2, 'e', 12)", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(identifier_columns => array('id','age'), table => '%s')", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "e", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, UPDATE_BEFORE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", 11, UPDATE_AFTER, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", 13, INSERT, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testRemoveCarryOversWithoutUpdatedRows() {
        this.createTableWithThreeColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a', 12), (2, 'b', 11), (2, 'e', 12)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c', 13), (2, 'd', 11), (2, 'e', 12)", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s')", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "e", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{2, "b", 11, DELETE, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{2, "d", 11, INSERT, 1, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", 13, INSERT, 1, snap2.snapshotId()})), this.sql("select * from %s order by _change_ordinal, id, data", new Object[]{viewName}));
    }

    @Test
    public void testNetChangesWithRemoveCarryOvers() {
        this.createTableWithThreeColumns();
        this.sql("INSERT INTO %s VALUES (1, 'a', 12), (2, 'b', 11), (2, 'e', 12)", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot snap1 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c', 13), (2, 'd', 11), (2, 'e', 12)", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap2 = table.currentSnapshot();
        this.sql("INSERT OVERWRITE %s VALUES (3, 'c', 15), (2, 'e', 12)", new Object[]{this.tableName});
        table.refresh();
        Snapshot snap3 = table.currentSnapshot();
        List returns = this.sql("CALL %s.system.create_changelog_view(table => '%s', net_changes => true)", new Object[]{this.catalogName, this.tableName});
        String viewName = (String)((Object[])returns.get(0))[0];
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a", 12, INSERT, 0, snap1.snapshotId()}), (Object)this.row(new Object[]{3, "c", 15, INSERT, 2, snap3.snapshotId()}), (Object)this.row(new Object[]{2, "e", 12, INSERT, 2, snap3.snapshotId()})), this.sql("select * from %s order by _change_ordinal, data", new Object[]{viewName}));
        this.sql("CALL %s.system.create_changelog_view(table => '%s', options => map('start-snapshot-id','%s'), net_changes => true)", new Object[]{this.catalogName, this.tableName, snap1.snapshotId()});
        this.assertEquals("Rows should match", (List)ImmutableList.of((Object)this.row(new Object[]{2, "b", 11, DELETE, 0, snap2.snapshotId()}), (Object)this.row(new Object[]{3, "c", 15, INSERT, 1, snap3.snapshotId()})), this.sql("select * from %s order by _change_ordinal, data", new Object[]{viewName}));
    }

    @Test
    public void testNetChangesWithComputeUpdates() {
        this.createTableWithTwoColumns();
        Assert.assertThrows((String)"Should fail because net_changes is not supported with computing updates", IllegalArgumentException.class, () -> this.sql("CALL %s.system.create_changelog_view(table => '%s', identifier_columns => array('id'), net_changes => true)", new Object[]{this.catalogName, this.tableName}));
    }
}

