/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMigrateTableProcedure
extends SparkExtensionsTestBase {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    public TestMigrateTableProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s_BACKUP_", new Object[]{this.tableName});
    }

    @Test
    public void testMigrate() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        String tableLocation = createdTable.location().replace("file:", "");
        Assert.assertEquals((String)"Table should have original location", (Object)location, (Object)tableLocation);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName + "_BACKUP_"});
    }

    @Test
    public void testMigrateWithOptions() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s', map('foo', 'bar'))", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        Table createdTable = this.validationCatalog.loadTable(this.tableIdent);
        Map props = createdTable.properties();
        Assert.assertEquals((String)"Should have extra property set", (Object)"bar", props.get("foo"));
        String tableLocation = createdTable.location().replace("file:", "");
        Assert.assertEquals((String)"Table should have original location", (Object)location, (Object)tableLocation);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName + "_BACKUP_"});
    }

    @Test
    public void testMigrateWithDropBackup() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate(table => '%s', drop_backup => true)", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        Assert.assertFalse((boolean)spark.catalog().tableExists(this.tableName + "_BACKUP_"));
    }

    @Test
    public void testMigrateWithInvalidMetricsConfig() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        AssertHelpers.assertThrows((String)"Should reject invalid metrics config", ValidationException.class, (String)"Invalid metrics config", () -> {
            String props = "map('write.metadata.metrics.column.x', 'X')";
            this.sql("CALL %s.system.migrate('%s', %s)", new Object[]{this.catalogName, this.tableName, props});
        });
    }

    @Test
    public void testMigrateWithConflictingProps() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s', map('migrated', 'false'))", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((String)"Should have added one file", (Object)1L, (Object)result);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should override user value", (Object)"true", table.properties().get("migrated"));
    }

    @Test
    public void testInvalidMigrateCases() {
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.migrate()", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid arg types", AnalysisException.class, (String)"Wrong arg type", () -> this.sql("CALL %s.system.migrate(map('foo','bar'))", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.migrate('')", new Object[]{this.catalogName}));
    }

    @Test
    public void testMigratePartitionWithSpecialCharacter() throws IOException {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string, dt date) USING parquet PARTITIONED BY (data, dt) LOCATION '%s'", new Object[]{this.tableName, location});
        this.sql("INSERT INTO TABLE %s VALUES (1, '2023/05/30', date '2023-05-30')", new Object[]{this.tableName});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "2023/05/30", Date.valueOf("2023-05-30")})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testMigrateEmptyPartitionedTable() throws Exception {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet PARTITIONED BY (id) LOCATION '%s'", new Object[]{this.tableName, location});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((Object)0L, (Object)result);
    }

    @Test
    public void testMigrateEmptyTable() throws Exception {
        Assume.assumeTrue((boolean)this.catalogName.equals("spark_catalog"));
        String location = this.temp.newFolder().toString();
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING parquet LOCATION '%s'", new Object[]{this.tableName, location});
        Object result = this.scalarSql("CALL %s.system.migrate('%s')", new Object[]{this.catalogName, this.tableName});
        Assert.assertEquals((Object)0L, (Object)result);
    }
}

