/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestRegisterTableProcedure
extends SparkExtensionsTestBase {
    private final String targetName;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    public TestRegisterTableProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.targetName = this.tableName("register_table");
    }

    @After
    public void dropTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.targetName});
    }

    @Test
    public void testRegisterTable() throws NoSuchTableException, ParseException {
        long numRows = 1000L;
        this.sql("CREATE TABLE %s (id int, data string) using ICEBERG", new Object[]{this.tableName});
        spark.range(0L, numRows).withColumn("data", functions.col((String)"id").cast(DataTypes.StringType)).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        long originalFileCount = (Long)this.scalarSql("SELECT COUNT(*) from %s.files", new Object[]{this.tableName});
        long currentSnapshotId = table.currentSnapshot().snapshotId();
        String metadataJson = ((HasTableOperations)table).operations().current().metadataFileLocation();
        List result = this.sql("CALL %s.system.register_table('%s', '%s')", new Object[]{this.catalogName, this.targetName, metadataJson});
        Assert.assertEquals((String)"Current Snapshot is not correct", (Object)currentSnapshotId, (Object)((Object[])result.get(0))[0]);
        List original = this.sql("SELECT * FROM %s", new Object[]{this.tableName});
        List registered = this.sql("SELECT * FROM %s", new Object[]{this.targetName});
        this.assertEquals("Registered table rows should match original table rows", original, registered);
        Assert.assertEquals((String)"Should have the right row count in the procedure result", (Object)numRows, (Object)((Object[])result.get(0))[1]);
        Assert.assertEquals((String)"Should have the right datafile count in the procedure result", (Object)originalFileCount, (Object)((Object[])result.get(0))[2]);
    }
}

