/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestReplaceBranch
extends SparkExtensionsTestBase {
    private static final String[] TIME_UNITS = new String[]{"DAYS", "HOURS", "MINUTES"};

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}};
    }

    public TestReplaceBranch(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testReplaceBranchFailsForTag() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        String tagName = "tag1";
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag(tagName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Cannot perform replace branch on tags", IllegalArgumentException.class, (String)"Ref tag1 is a tag not a branch", () -> this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, tagName, second}));
    }

    @Test
    public void testReplaceBranch() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        long expectedMaxRefAgeMs = 1000L;
        int expectedMinSnapshotsToKeep = 2;
        long expectedMaxSnapshotAgeMs = 1000L;
        table.manageSnapshots().createBranch(branchName, first).setMaxRefAgeMs(branchName, expectedMaxRefAgeMs).setMinSnapshotsToKeep(branchName, expectedMinSnapshotsToKeep).setMaxSnapshotAgeMs(branchName, expectedMaxSnapshotAgeMs).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, second});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertNotNull((Object)ref);
        Assert.assertEquals((long)second, (long)ref.snapshotId());
        Assert.assertEquals((long)expectedMinSnapshotsToKeep, (long)ref.minSnapshotsToKeep().intValue());
        Assert.assertEquals((long)expectedMaxSnapshotAgeMs, (long)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)expectedMaxRefAgeMs, (long)ref.maxRefAgeMs());
    }

    @Test
    public void testReplaceBranchDoesNotExist() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        AssertHelpers.assertThrows((String)"Cannot perform replace branch on branch which does not exist", IllegalArgumentException.class, (String)"Branch does not exist", () -> this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, "someBranch", table.currentSnapshot().snapshotId()}));
    }

    @Test
    public void testReplaceBranchWithRetain() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, first).commit();
        SnapshotRef b1 = (SnapshotRef)table.refs().get(branchName);
        Integer minSnapshotsToKeep = b1.minSnapshotsToKeep();
        Long maxSnapshotAgeMs = b1.maxSnapshotAgeMs();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, branchName, second, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assert.assertNotNull((Object)ref);
            Assert.assertEquals((long)second, (long)ref.snapshotId());
            Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
            Assert.assertEquals((Object)maxSnapshotAgeMs, (Object)ref.maxSnapshotAgeMs());
            Assert.assertEquals((long)TimeUnit.valueOf(timeUnit).toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        }
    }

    @Test
    public void testReplaceBranchWithSnapshotRetention() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        String branchName = "b1";
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        Long maxRefAgeMs = ((SnapshotRef)table.refs().get(branchName)).maxRefAgeMs();
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d WITH SNAPSHOT RETENTION %d SNAPSHOTS %d %s", new Object[]{this.tableName, branchName, second, minSnapshotsToKeep, maxSnapshotAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assert.assertNotNull((Object)ref);
            Assert.assertEquals((long)second, (long)ref.snapshotId());
            Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
            Assert.assertEquals((long)TimeUnit.valueOf(timeUnit).toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
            Assert.assertEquals((Object)maxRefAgeMs, (Object)ref.maxRefAgeMs());
        }
    }

    @Test
    public void testReplaceBranchWithRetainAndSnapshotRetention() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, first).commit();
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d RETAIN %d %s WITH SNAPSHOT RETENTION %d SNAPSHOTS %d %s", new Object[]{this.tableName, branchName, second, maxRefAge, timeUnit, minSnapshotsToKeep, maxSnapshotAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
            Assert.assertNotNull((Object)ref);
            Assert.assertEquals((long)second, (long)ref.snapshotId());
            Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
            Assert.assertEquals((long)TimeUnit.valueOf(timeUnit).toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
            Assert.assertEquals((long)TimeUnit.valueOf(timeUnit).toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        }
    }

    @Test
    public void testCreateOrReplace() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        df.writeTo(this.tableName).append();
        long second = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, second).commit();
        this.sql("ALTER TABLE %s CREATE OR REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, first});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertNotNull((Object)ref);
        Assert.assertEquals((long)first, (long)ref.snapshotId());
    }
}

