/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Zorder;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.ExtendedParser;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestRewriteDataFilesProcedure
extends SparkExtensionsTestBase {
    private static final String QUOTED_SPECIAL_CHARS_TABLE_NAME = "`table:with.special:chars`";

    public TestRewriteDataFilesProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
    }

    @Test
    public void testZOrderSortExpression() {
        List order = ExtendedParser.parseSortOrder((SparkSession)spark, (String)"c1, zorder(c2, c3)");
        Assert.assertEquals((String)"Should parse 2 order fields", (long)2L, (long)order.size());
        Assert.assertEquals((String)"First field should be a ref", (Object)"c1", (Object)((NamedReference)((ExtendedParser.RawOrderField)order.get(0)).term()).name());
        Assert.assertTrue((String)"Second field should be zorder", (boolean)(((ExtendedParser.RawOrderField)order.get(1)).term() instanceof Zorder));
    }

    @Test
    public void testRewriteDataFilesInEmptyTable() {
        this.createTable();
        List output = this.sql("CALL %s.system.rewrite_data_files('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0, 0L})), output);
    }

    @Test
    public void testRewriteDataFilesOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 2 data files (one per partition) ", this.row(new Object[]{10, 2}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesOnNonPartitionTable() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithOptions() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', options => map('min-input-files','12'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 0 data files and add 0 data files", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0, 0L})), output);
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithSortStrategy() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 DESC NULLS LAST')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithZOrder() {
        this.createTable();
        this.insertData(10);
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'zorder(c1,c2)')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{2, "bar", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}), (Object)this.row(new Object[]{1, "foo", null}));
        this.assertEquals("Should have expected rows", (List)expectedRows, this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void testRewriteDataFilesWithFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 1 and c2 is not null')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files (containing c1 = 1) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithDeterministicTrueFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '1=1')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 10 data files and add 1 data files", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithDeterministicFalseFilter() {
        this.createTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => '0=1')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 0 data files and add 0 data files", this.row(new Object[]{0, 0}), Arrays.copyOf((Object[])output.get(0), 2));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithFilterOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 = \"bar\"')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files from single matching partition(containing c2 = bar) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithInFilterOnPartitionTable() {
        this.createPartitionTable();
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 in (\"bar\")')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 5 data files from single matching partition(containing c2 = bar) and add 1 data files", this.row(new Object[]{5, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteDataFilesWithAllPossibleFilters() {
        this.createPartitionTable();
        this.insertData(10);
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 > 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 >= 3')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 < 0')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 <= 0')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 in (3,4,5)')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 is null')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c3 is not null')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3 and c2 = \"bar\"')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 = 3 or c1 = 5')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c1 not in (1,2)')", new Object[]{this.catalogName, this.tableIdent});
        this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 like \"%s\"')", new Object[]{this.catalogName, this.tableIdent, "car%"});
    }

    @Test
    public void testRewriteDataFilesWithInvalidInputs() {
        this.createTable();
        this.insertData(2);
        AssertHelpers.assertThrows((String)"Should reject calls with unsupported strategy error message", IllegalArgumentException.class, (String)"unsupported strategy: temp. Only binpack or sort is supported", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', options => map('min-input-files','2'), strategy => 'temp')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Must use only one rewriter type (bin-pack, sort, zorder)", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'binpack', sort_order => 'c1 ASC NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Cannot sort data without a valid sort order", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Unable to parse sortOrder:", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 ASC none')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Unable to parse sortOrder:", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1 none NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", ValidationException.class, (String)"Cannot find field 'col1' in struct: struct<1: c1: optional int, 2: c2: optional string, 3: c3: optional string>", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'col1 DESC NULLS FIRST')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Cannot parse predicates in where option: col1 = 3", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'col1 = 3')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Cannot find column 'col1' in table schema (case sensitive = false): struct<1: c1: optional int, 2: c2: optional string, 3: c3: optional string>", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'zorder(col1)')", new Object[]{this.catalogName, this.tableIdent}));
        AssertHelpers.assertThrows((String)"Should reject calls with error message", IllegalArgumentException.class, (String)"Cannot mix identity sort columns and a Zorder sort expression: c1,zorder(c2,c3)", () -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', sort_order => 'c1,zorder(c2,c3)')", new Object[]{this.catalogName, this.tableIdent}));
    }

    @Test
    public void testInvalidCasesForRewriteDataFiles() {
        AssertHelpers.assertThrows((String)"Should not allow mixed args", AnalysisException.class, (String)"Named and positional arguments cannot be mixed", () -> this.sql("CALL %s.system.rewrite_data_files('n', table => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should not resolve procedures in arbitrary namespaces", NoSuchProcedureException.class, (String)"not found", () -> this.sql("CALL %s.custom.rewrite_data_files('n', 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.rewrite_data_files()", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject duplicate arg names name", AnalysisException.class, (String)"Duplicate procedure argument: table", () -> this.sql("CALL %s.system.rewrite_data_files(table => 't', table => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.rewrite_data_files('')", new Object[]{this.catalogName}));
    }

    @Test
    public void testBinPackTableWithSpecialChars() {
        Assume.assumeTrue((boolean)this.catalogName.equals(SparkCatalogConfig.HADOOP.catalogName()));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        Assertions.assertThat((Object)((Object[])output.get(0))[2]).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        Assert.assertEquals((String)"Table cache must be empty", (long)0L, (long)SparkTableCache.get().size());
    }

    @Test
    public void testSortTableWithSpecialChars() {
        Assume.assumeTrue((boolean)this.catalogName.equals(SparkCatalogConfig.HADOOP.catalogName()));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(  table => '%s',  strategy => 'sort',  sort_order => 'c1',  where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        Assert.assertEquals((String)"Table cache must be empty", (long)0L, (long)SparkTableCache.get().size());
    }

    @Test
    public void testZOrderTableWithSpecialChars() {
        Assume.assumeTrue((boolean)this.catalogName.equals(SparkCatalogConfig.HADOOP.catalogName()));
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"default", QUOTED_SPECIAL_CHARS_TABLE_NAME.replaceAll("`", "")});
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.insertData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME), 10);
        List<Object[]> expectedRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        List output = this.sql("CALL %s.system.rewrite_data_files(  table => '%s',  strategy => 'sort',  sort_order => 'zorder(c1, c2)',  where => 'c2 is not null')", new Object[]{this.catalogName, this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME)});
        this.assertEquals("Action should rewrite 10 data files and add 1 data file", this.row(new Object[]{10, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary(identifier).get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData(this.tableName(QUOTED_SPECIAL_CHARS_TABLE_NAME));
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
        Assert.assertEquals((String)"Table cache must be empty", (long)0L, (long)SparkTableCache.get().size());
    }

    @Test
    public void testDefaultSortOrder() {
        this.createTable();
        this.sql("ALTER TABLE %s WRITE ORDERED BY c2", new Object[]{this.tableName});
        this.insertData(10);
        List<Object[]> expectedRecords = this.currentData();
        List output = this.sql("CALL %s.system.rewrite_data_files(table => '%s', strategy => 'sort', options => map('min-input-files','2'))", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Action should rewrite 2 data files and add 1 data files", this.row(new Object[]{2, 1}), Arrays.copyOf((Object[])output.get(0), 2));
        Assertions.assertThat((Object[])((Object[])output.get(0))).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((Object[])output.get(0))[2]).isInstanceOf(Long.class)).isEqualTo((Object)Long.valueOf(this.snapshotSummary().get("removed-files-size")));
        List<Object[]> actualRecords = this.currentData();
        this.assertEquals("Data after compaction should not change", expectedRecords, actualRecords);
    }

    @Test
    public void testRewriteWithUntranslatedOrUnconvertedFilter() {
        this.createTable();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'lower(c2) = \"fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot translate Spark expression");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_data_files(table => '%s', where => 'c2 like \"%%fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot convert Spark filter");
    }

    private void createTable() {
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg", new Object[]{this.tableName});
    }

    private void createPartitionTable() {
        this.sql("CREATE TABLE %s (c1 int, c2 string, c3 string) USING iceberg PARTITIONED BY (c2) TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.distribution-mode", "none"});
    }

    private void insertData(int filesCount) {
        this.insertData(this.tableName, filesCount);
    }

    private void insertData(String table, int filesCount) {
        ThreeColumnRecord record1 = new ThreeColumnRecord(Integer.valueOf(1), "foo", null);
        ThreeColumnRecord record2 = new ThreeColumnRecord(Integer.valueOf(2), "bar", null);
        ArrayList records = Lists.newArrayList();
        IntStream.range(0, filesCount / 2).forEach(i -> {
            records.add(record1);
            records.add(record2);
        });
        Dataset df = spark.createDataFrame((List)records, ThreeColumnRecord.class).repartition(filesCount);
        try {
            df.writeTo(table).append();
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> snapshotSummary() {
        return this.snapshotSummary(this.tableIdent);
    }

    private Map<String, String> snapshotSummary(TableIdentifier tableIdentifier) {
        return this.validationCatalog.loadTable(tableIdentifier).currentSnapshot().summary();
    }

    private List<Object[]> currentData() {
        return this.currentData(this.tableName);
    }

    private List<Object[]> currentData(String table) {
        return this.rowsToJava(spark.sql("SELECT * FROM " + table + " order by c1, c2, c3").collectAsList());
    }
}

