/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestRewriteManifestsProcedure
extends SparkExtensionsTestBase {
    public TestRewriteManifestsProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testRewriteManifestsInEmptyTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0})), output);
    }

    @Test
    public void testRewriteLargeManifests() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Must have 1 manifest", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('commit.manifest.target-size-bytes' '1')", new Object[]{this.tableName});
        List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{1, 4})), output);
        table.refresh();
        Assert.assertEquals((String)"Must have 4 manifests", (long)4L, (long)table.currentSnapshot().allManifests(table.io()).size());
    }

    @Test
    public void testRewriteManifestsNoOp() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Must have 1 manifest", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0})), output);
        table.refresh();
        Assert.assertEquals((String)"Must have 1 manifests", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
    }

    @Test
    public void testRewriteLargeManifestsOnDatePartitionedTableWithJava8APIEnabled() {
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.datetime.java8API.enabled", (Object)"true"), () -> {
            this.sql("CREATE TABLE %s (id INTEGER, name STRING, dept STRING, ts DATE) USING iceberg PARTITIONED BY (ts)", new Object[]{this.tableName});
            try {
                spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", "hr", Date.valueOf("2021-01-01")}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", "hr", Date.valueOf("2021-01-02")}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", "hr", Date.valueOf("2021-01-03")}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", "facilities", Date.valueOf("2021-01-04")})), spark.table(this.tableName).schema()).writeTo(this.tableName).append();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            Assert.assertEquals((String)"Must have 1 manifest", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
            this.sql("ALTER TABLE %s SET TBLPROPERTIES ('commit.manifest.target-size-bytes' '1')", new Object[]{this.tableName});
            List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
            this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{1, 4})), output);
            table.refresh();
            Assert.assertEquals((String)"Must have 4 manifests", (long)4L, (long)table.currentSnapshot().allManifests(table.io()).size());
        });
    }

    @Test
    public void testRewriteLargeManifestsOnTimestampPartitionedTableWithJava8APIEnabled() {
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.datetime.java8API.enabled", (Object)"true"), () -> {
            this.sql("CREATE TABLE %s (id INTEGER, name STRING, dept STRING, ts TIMESTAMP) USING iceberg PARTITIONED BY (ts)", new Object[]{this.tableName});
            try {
                spark.createDataFrame((List)ImmutableList.of((Object)RowFactory.create((Object[])new Object[]{1, "John Doe", "hr", Timestamp.valueOf("2021-01-01 00:00:00")}), (Object)RowFactory.create((Object[])new Object[]{2, "Jane Doe", "hr", Timestamp.valueOf("2021-01-02 00:00:00")}), (Object)RowFactory.create((Object[])new Object[]{3, "Matt Doe", "hr", Timestamp.valueOf("2021-01-03 00:00:00")}), (Object)RowFactory.create((Object[])new Object[]{4, "Will Doe", "facilities", Timestamp.valueOf("2021-01-04 00:00:00")})), spark.table(this.tableName).schema()).writeTo(this.tableName).append();
            }
            catch (NoSuchTableException e) {
                throw new RuntimeException(e);
            }
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            Assert.assertEquals((String)"Must have 1 manifest", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
            this.sql("ALTER TABLE %s SET TBLPROPERTIES ('commit.manifest.target-size-bytes' '1')", new Object[]{this.tableName});
            List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
            this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{1, 4})), output);
            table.refresh();
            Assert.assertEquals((String)"Must have 4 manifests", (long)4L, (long)table.currentSnapshot().allManifests(table.io()).size());
        });
    }

    @Test
    public void testRewriteSmallManifestsWithSnapshotIdInheritance() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "compatibility.snapshot-id-inheritance.enabled", "true"});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Must have 4 manifest", (long)4L, (long)table.currentSnapshot().allManifests(table.io()).size());
        List output = this.sql("CALL %s.system.rewrite_manifests(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{4, 1})), output);
        table.refresh();
        Assert.assertEquals((String)"Must have 1 manifests", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
    }

    @Test
    public void testRewriteSmallManifestsWithoutCaching() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Must have 2 manifest", (long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        List output = this.sql("CALL %s.system.rewrite_manifests(use_caching => false, table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2, 1})), output);
        table.refresh();
        Assert.assertEquals((String)"Must have 1 manifests", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
    }

    @Test
    public void testRewriteManifestsCaseInsensitiveArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (data)", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Must have 2 manifest", (long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        List output = this.sql("CALL %s.system.rewrite_manifests(usE_cAcHiNg => false, tAbLe => '%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{2, 1})), output);
        table.refresh();
        Assert.assertEquals((String)"Must have 1 manifests", (long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
    }

    @Test
    public void testInvalidRewriteManifestsCases() {
        AssertHelpers.assertThrows((String)"Should not allow mixed args", AnalysisException.class, (String)"Named and positional arguments cannot be mixed", () -> this.sql("CALL %s.system.rewrite_manifests('n', table => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should not resolve procedures in arbitrary namespaces", NoSuchProcedureException.class, (String)"not found", () -> this.sql("CALL %s.custom.rewrite_manifests('n', 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.rewrite_manifests()", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid arg types", AnalysisException.class, (String)"Wrong arg type", () -> this.sql("CALL %s.system.rewrite_manifests('n', 2.2)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject duplicate arg names name", AnalysisException.class, (String)"Duplicate procedure argument: table", () -> this.sql("CALL %s.system.rewrite_manifests(table => 't', tAbLe => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.rewrite_manifests('')", new Object[]{this.catalogName}));
    }

    @Test
    public void testReplacePartitionField() {
        this.sql("CREATE TABLE %s (id int, ts timestamp, day_of_ts date) USING iceberg PARTITIONED BY (day_of_ts)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('format-version' = '2')", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s REPLACE PARTITION FIELD day_of_ts WITH days(ts)\n", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, CAST('2022-01-01 10:00:00' AS TIMESTAMP), CAST('2022-01-01' AS DATE))", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, Timestamp.valueOf("2022-01-01 10:00:00"), Date.valueOf("2022-01-01")})), this.sql("SELECT * FROM %s WHERE ts < current_timestamp()", new Object[]{this.tableName}));
        this.sql("CALL %s.system.rewrite_manifests(table => '%s')", new Object[]{this.catalogName, this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, Timestamp.valueOf("2022-01-01 10:00:00"), Date.valueOf("2022-01-01")})), this.sql("SELECT * FROM %s WHERE ts < current_timestamp()", new Object[]{this.tableName}));
    }

    @Test
    public void testWriteManifestWithSpecId() {
        this.sql("CREATE TABLE %s (id int, dt string, hr string) USING iceberg PARTITIONED BY (dt)", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('commit.manifest-merge.enabled' = 'false')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (1, '2024-01-01', '00')", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (2, '2024-01-01', '00')", new Object[]{this.tableName});
        this.assertEquals("Should have 2 manifests and their partition spec id should be 0", (List)ImmutableList.of((Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{0})), this.sql("SELECT partition_spec_id FROM %s.manifests order by 1 asc", new Object[]{this.tableName}));
        this.sql("ALTER TABLE %s ADD PARTITION FIELD hr", new Object[]{this.tableName});
        this.sql("INSERT INTO %s VALUES (3, '2024-01-01', '00')", new Object[]{this.tableName});
        this.assertEquals("Should have 3 manifests and their partition spec id should be 0 and 1", (List)ImmutableList.of((Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1})), this.sql("SELECT partition_spec_id FROM %s.manifests order by 1 asc", new Object[]{this.tableName}));
        List output = this.sql("CALL %s.system.rewrite_manifests('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Nothing should be rewritten", (List)ImmutableList.of((Object)this.row(new Object[]{0, 0})), output);
        output = this.sql("CALL %s.system.rewrite_manifests(table => '%s', spec_id => 0)", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("There should be 2 manifests rewriten", (List)ImmutableList.of((Object)this.row(new Object[]{2, 1})), output);
        this.assertEquals("Should have 2 manifests and their partition spec id should be 0 and 1", (List)ImmutableList.of((Object)this.row(new Object[]{0}), (Object)this.row(new Object[]{1})), this.sql("SELECT partition_spec_id FROM %s.manifests order by 1 asc", new Object[]{this.tableName}));
    }
}

