/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Encoders;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestRewritePositionDeleteFilesProcedure
extends SparkExtensionsTestBase {
    public TestRewritePositionDeleteFilesProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    private void createTable() throws Exception {
        this.createTable(false);
    }

    private void createTable(boolean partitioned) throws Exception {
        String partitionStmt = partitioned ? "PARTITIONED BY (id)" : "";
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg %s TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName, partitionStmt});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(1), "c"), new SimpleRecord(Integer.valueOf(2), "d"), new SimpleRecord(Integer.valueOf(2), "e"), new SimpleRecord(Integer.valueOf(2), "f"), new SimpleRecord(Integer.valueOf(3), "g"), new SimpleRecord(Integer.valueOf(3), "h"), new SimpleRecord(Integer.valueOf(3), "i"), new SimpleRecord(Integer.valueOf(4), "j"), new SimpleRecord(Integer.valueOf(4), "k"), new SimpleRecord(Integer.valueOf(4), "l"), new SimpleRecord(Integer.valueOf(5), "m"), new SimpleRecord(Integer.valueOf(5), "n"), new SimpleRecord(Integer.valueOf(5), "o"), new SimpleRecord(Integer.valueOf(6), "p"), new SimpleRecord(Integer.valueOf(6), "q"), new SimpleRecord(Integer.valueOf(6), "r")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testExpireDeleteFilesAll() throws Exception {
        this.createTable();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=2", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((long)2L, (long)TestHelpers.deleteFiles((Table)table).size());
        List output = this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s',options => map('rewrite-all','true'))", new Object[]{this.catalogName, this.tableIdent});
        table.refresh();
        Map<String, String> snapshotSummary = this.snapshotSummary();
        this.assertEquals("Should delete 2 delete files and add 1", (List)ImmutableList.of((Object)this.row(new Object[]{2, 1, Long.valueOf(snapshotSummary.get("removed-files-size")), Long.valueOf(snapshotSummary.get("added-files-size"))})), output);
        Assert.assertEquals((long)1L, (long)TestHelpers.deleteFiles((Table)table).size());
    }

    @Test
    public void testExpireDeleteFilesNoOption() throws Exception {
        this.createTable();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=2", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=3", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=4", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=5", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((long)5L, (long)TestHelpers.deleteFiles((Table)table).size());
        List output = this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s')", new Object[]{this.catalogName, this.tableIdent});
        table.refresh();
        Map<String, String> snapshotSummary = this.snapshotSummary();
        this.assertEquals("Should replace 5 delete files with 1", (List)ImmutableList.of((Object)this.row(new Object[]{5, 1, Long.valueOf(snapshotSummary.get("removed-files-size")), Long.valueOf(snapshotSummary.get("added-files-size"))})), output);
    }

    @Test
    public void testExpireDeleteFilesFilter() throws Exception {
        this.createTable(true);
        this.sql("DELETE FROM %s WHERE id = 1 and data='a'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 1 and data='b'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 2 and data='d'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 2 and data='e'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 3 and data='g'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id = 3 and data='h'", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((long)6L, (long)TestHelpers.deleteFiles((Table)table).size());
        List output = this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s',where => 'id IN (1, 2) AND data=\"bar\"',options => map('rewrite-all','true'))", new Object[]{this.catalogName, this.tableIdent});
        table.refresh();
        Map<String, String> snapshotSummary = this.snapshotSummary();
        this.assertEquals("Should delete 4 delete files and add 2", (List)ImmutableList.of((Object)this.row(new Object[]{4, 2, Long.valueOf(snapshotSummary.get("removed-files-size")), Long.valueOf(snapshotSummary.get("added-files-size"))})), output);
        Assert.assertEquals((long)4L, (long)TestHelpers.deleteFiles((Table)table).size());
    }

    @Test
    public void testInvalidOption() throws Exception {
        this.createTable();
        Assert.assertThrows((String)"Cannot use options [foo], they are not supported by the action or the rewriter BIN-PACK", IllegalArgumentException.class, () -> this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s',options => map('foo', 'bar'))", new Object[]{this.catalogName, this.tableIdent}));
    }

    @Test
    public void testRewriteWithUntranslatedOrUnconvertedFilter() throws Exception {
        this.createTable();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s', where => 'lower(data) = \"fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot translate Spark expression");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.rewrite_position_delete_files(table => '%s', where => 'data like \"%%fo\"')", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot convert Spark filter");
    }

    private Map<String, String> snapshotSummary() {
        return this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().summary();
    }
}

