/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;

public class TestRollbackToSnapshotProcedure
extends SparkExtensionsTestBase {
    public TestRollbackToSnapshotProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testRollbackToSnapshotUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testRollbackToSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.rollback_to_snapshot(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, firstSnapshot.snapshotId(), this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testRollbackToSnapshotRefreshesRelationCache() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        Dataset query = spark.sql("SELECT * FROM " + this.tableName + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        spark.sql("CACHE TABLE tmp");
        this.assertEquals("View should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        List output = this.sql("CALL %s.system.rollback_to_snapshot(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("View cache must be invalidated", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("UNCACHE TABLE tmp", new Object[0]);
    }

    @Test
    public void testRollbackToSnapshotWithQuotedIdentifiers() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        StringBuilder quotedNamespaceBuilder = new StringBuilder();
        for (String level : this.tableIdent.namespace().levels()) {
            quotedNamespaceBuilder.append("`");
            quotedNamespaceBuilder.append(level);
            quotedNamespaceBuilder.append("`");
        }
        String quotedNamespace = quotedNamespaceBuilder.toString();
        List output = this.sql("CALL %s.system.rollback_to_snapshot('%s', %d)", new Object[]{this.catalogName, quotedNamespace + ".`" + this.tableIdent.name() + "`", firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testRollbackToSnapshotWithoutExplicitCatalog() {
        Assume.assumeTrue((String)"Working only with the session catalog", (boolean)"spark_catalog".equals(this.catalogName));
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL SyStEm.rOLlBaCk_to_SnApShOt('%s', %dL)", new Object[]{this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Rollback must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testRollbackToInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        AssertHelpers.assertThrows((String)"Should reject invalid snapshot id", ValidationException.class, (String)"Cannot roll back to unknown snapshot id", () -> this.sql("CALL %s.system.rollback_to_snapshot('%s', -1L)", new Object[]{this.catalogName, this.tableIdent}));
    }

    @Test
    public void testInvalidRollbackToSnapshotCases() {
        AssertHelpers.assertThrows((String)"Should not allow mixed args", AnalysisException.class, (String)"Named and positional arguments cannot be mixed", () -> this.sql("CALL %s.system.rollback_to_snapshot(namespace => 'n1', table => 't', 1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should not resolve procedures in arbitrary namespaces", NoSuchProcedureException.class, (String)"not found", () -> this.sql("CALL %s.custom.rollback_to_snapshot('n', 't', 1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.rollback_to_snapshot('t')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.rollback_to_snapshot(1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.rollback_to_snapshot(table => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid arg types", AnalysisException.class, (String)"Wrong arg type for snapshot_id: cannot cast", () -> this.sql("CALL %s.system.rollback_to_snapshot('t', 2.2)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.rollback_to_snapshot('', 1L)", new Object[]{this.catalogName}));
    }
}

