/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;

public class TestSetCurrentSnapshotProcedure
extends SparkExtensionsTestBase {
    public TestSetCurrentSnapshotProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testSetCurrentSnapshotUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.set_current_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testSetCurrentSnapshotUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL %s.system.set_current_snapshot(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, firstSnapshot.snapshotId(), this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testSetCurrentSnapshotWap() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' 'true')", new Object[]{this.tableName, "write.wap.enabled"});
        spark.conf().set("spark.wap.id", "1");
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should not see rows from staged snapshot", (List)ImmutableList.of(), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot wapSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)table.snapshots());
        List output = this.sql("CALL %s.system.set_current_snapshot(table => '%s', snapshot_id => %dL)", new Object[]{this.catalogName, this.tableIdent, wapSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{null, wapSnapshot.snapshotId()})), output);
        this.assertEquals("Current snapshot must be set correctly", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s", new Object[]{this.tableName}));
    }

    @Test
    public void tesSetCurrentSnapshotWithoutExplicitCatalog() {
        Assume.assumeTrue((String)"Working only with the session catalog", (boolean)"spark_catalog".equals(this.catalogName));
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Snapshot firstSnapshot = table.currentSnapshot();
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"}), (Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        List output = this.sql("CALL SyStEm.sEt_cuRrEnT_sNaPsHot('%s', %dL)", new Object[]{this.tableIdent, firstSnapshot.snapshotId()});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{secondSnapshot.snapshotId(), firstSnapshot.snapshotId()})), output);
        this.assertEquals("Set must be successful", (List)ImmutableList.of((Object)this.row(new Object[]{1L, "a"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{this.tableName}));
    }

    @Test
    public void testSetCurrentSnapshotToInvalidSnapshot() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        Namespace namespace = this.tableIdent.namespace();
        String tableName = this.tableIdent.name();
        AssertHelpers.assertThrows((String)"Should reject invalid snapshot id", ValidationException.class, (String)"Cannot roll back to unknown snapshot id", () -> this.sql("CALL %s.system.set_current_snapshot('%s', -1L)", new Object[]{this.catalogName, this.tableIdent}));
    }

    @Test
    public void testInvalidRollbackToSnapshotCases() {
        AssertHelpers.assertThrows((String)"Should not allow mixed args", AnalysisException.class, (String)"Named and positional arguments cannot be mixed", () -> this.sql("CALL %s.system.set_current_snapshot(namespace => 'n1', table => 't', 1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should not resolve procedures in arbitrary namespaces", NoSuchProcedureException.class, (String)"not found", () -> this.sql("CALL %s.custom.set_current_snapshot('n', 't', 1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.set_current_snapshot('t')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.set_current_snapshot(1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.set_current_snapshot(snapshot_id => 1L)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls without all required args", AnalysisException.class, (String)"Missing required parameters", () -> this.sql("CALL %s.system.set_current_snapshot(table => 't')", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with invalid arg types", AnalysisException.class, (String)"Wrong arg type for snapshot_id: cannot cast", () -> this.sql("CALL %s.system.set_current_snapshot('t', 2.2)", new Object[]{this.catalogName}));
        AssertHelpers.assertThrows((String)"Should reject calls with empty table identifier", IllegalArgumentException.class, (String)"Cannot handle an empty identifier", () -> this.sql("CALL %s.system.set_current_snapshot('', 1L)", new Object[]{this.catalogName}));
    }
}

