/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.extensions.IcebergParseException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestTagDDL
extends SparkExtensionsTestBase {
    private static final String[] TIME_UNITS = new String[]{"DAYS", "HOURS", "MINUTES"};

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}};
    }

    public TestTagDDL(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void before() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testCreateTagWithRetain() throws NoSuchTableException {
        Table table = this.insertRows();
        long firstSnapshotId = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        for (String timeUnit : TIME_UNITS) {
            String tagName = "t1" + timeUnit;
            this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
            Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)firstSnapshotId, (long)ref.snapshotId());
            Assert.assertEquals((String)"The tag needs to have the correct max ref age.", (long)TimeUnit.valueOf(timeUnit.toUpperCase(Locale.ENGLISH)).toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        }
        String tagName = "t1";
        AssertHelpers.assertThrows((String)"Illegal statement", IcebergParseException.class, (String)"mismatched input", () -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge}));
        AssertHelpers.assertThrows((String)"Illegal statement", IcebergParseException.class, (String)"mismatched input", () -> this.sql("ALTER TABLE %s CREATE TAG %s RETAIN %s DAYS", new Object[]{this.tableName, tagName, "abc"}));
        AssertHelpers.assertThrows((String)"Illegal statement", IcebergParseException.class, (String)"mismatched input 'SECONDS' expecting {'DAYS', 'HOURS', 'MINUTES'}", () -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d RETAIN %d SECONDS", new Object[]{this.tableName, tagName, firstSnapshotId, maxRefAge}));
    }

    @Test
    public void testCreateTagOnEmptyTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, "abc"})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot complete create or replace tag operation on %s, main has no snapshot", new Object[]{this.tableName});
    }

    @Test
    public void testCreateTagUseDefaultConfig() throws NoSuchTableException {
        Table table = this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        AssertHelpers.assertThrows((String)"unknown snapshot", ValidationException.class, (String)"unknown snapshot: -1", () -> this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, -1}));
        this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, tagName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)snapshotId, (long)ref.snapshotId());
        Assert.assertNull((String)"The tag needs to have the default max ref age, which is null.", (Object)ref.maxRefAgeMs());
        AssertHelpers.assertThrows((String)"Cannot create an exist tag", IllegalArgumentException.class, (String)"already exists", () -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, tagName}));
        AssertHelpers.assertThrows((String)"Non-conforming tag name", IcebergParseException.class, (String)"mismatched input '123'", () -> this.sql("ALTER TABLE %s CREATE TAG %s", new Object[]{this.tableName, "123"}));
        table.manageSnapshots().removeTag(tagName).commit();
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        snapshotId = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s CREATE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, snapshotId});
        table.refresh();
        ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)snapshotId, (long)ref.snapshotId());
        Assert.assertNull((String)"The tag needs to have the default max ref age, which is null.", (Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateTagIfNotExists() throws NoSuchTableException {
        long maxSnapshotAge = 2L;
        Table table = this.insertRows();
        String tagName = "t1";
        this.sql("ALTER TABLE %s CREATE TAG %s RETAIN %d days", new Object[]{this.tableName, tagName, maxSnapshotAge});
        this.sql("ALTER TABLE %s CREATE TAG IF NOT EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((String)"The tag needs to have the correct max ref age.", (long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxRefAgeMs());
    }

    @Test
    public void testReplaceTagFailsForBranch() throws NoSuchTableException {
        String branchName = "branch1";
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, first).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Cannot perform replace tag on branches", IllegalArgumentException.class, (String)"Ref branch1 is a branch not a tag", () -> this.sql("ALTER TABLE %s REPLACE Tag %s", new Object[]{this.tableName, branchName, second}));
    }

    @Test
    public void testReplaceTag() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        long expectedMaxRefAgeMs = 1000L;
        table.manageSnapshots().createTag(tagName, first).setMaxRefAgeMs(tagName, expectedMaxRefAgeMs).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d", new Object[]{this.tableName, tagName, second});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)second, (long)ref.snapshotId());
        Assert.assertEquals((String)"The tag needs to have the correct max ref age.", (long)expectedMaxRefAgeMs, (long)ref.maxRefAgeMs());
    }

    @Test
    public void testReplaceTagDoesNotExist() throws NoSuchTableException {
        Table table = this.insertRows();
        AssertHelpers.assertThrows((String)"Cannot perform replace tag on tag which does not exist", IllegalArgumentException.class, (String)"Tag does not exist", () -> this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d", new Object[]{this.tableName, "someTag", table.currentSnapshot().snapshotId()}));
    }

    @Test
    public void testReplaceTagWithRetain() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        table.manageSnapshots().createTag(tagName, first).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        long maxRefAge = 10L;
        for (String timeUnit : TIME_UNITS) {
            this.sql("ALTER TABLE %s REPLACE Tag %s AS OF VERSION %d RETAIN %d %s", new Object[]{this.tableName, tagName, second, maxRefAge, timeUnit});
            table.refresh();
            SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
            Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)second, (long)ref.snapshotId());
            Assert.assertEquals((String)"The tag needs to have the correct max ref age.", (long)TimeUnit.valueOf(timeUnit).toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        }
    }

    @Test
    public void testCreateOrReplace() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String tagName = "t1";
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag(tagName, second).commit();
        this.sql("ALTER TABLE %s CREATE OR REPLACE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, first});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)first, (long)ref.snapshotId());
    }

    @Test
    public void testDropTag() throws NoSuchTableException {
        this.insertRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String tagName = "t1";
        table.manageSnapshots().createTag(tagName, table.currentSnapshot().snapshotId()).commit();
        SnapshotRef ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertEquals((String)"The tag needs to point to a specific snapshot id.", (long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, tagName});
        table.refresh();
        ref = (SnapshotRef)table.refs().get(tagName);
        Assert.assertNull((String)"The tag needs to be dropped.", (Object)ref);
    }

    @Test
    public void testDropTagNonConformingName() {
        AssertHelpers.assertThrows((String)"Non-conforming tag name", IcebergParseException.class, (String)"mismatched input '123'", () -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, "123"}));
    }

    @Test
    public void testDropTagDoesNotExist() {
        AssertHelpers.assertThrows((String)"Cannot perform drop tag on tag which does not exist", IllegalArgumentException.class, (String)"Tag does not exist: nonExistingTag", () -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, "nonExistingTag"}));
    }

    @Test
    public void testDropTagFailesForBranch() throws NoSuchTableException {
        String branchName = "b1";
        Table table = this.insertRows();
        table.manageSnapshots().createBranch(branchName, table.currentSnapshot().snapshotId()).commit();
        AssertHelpers.assertThrows((String)"Cannot perform drop tag on branch", IllegalArgumentException.class, (String)"Ref b1 is a branch not a tag", () -> this.sql("ALTER TABLE %s DROP TAG %s", new Object[]{this.tableName, branchName}));
    }

    @Test
    public void testDropTagIfExists() throws NoSuchTableException {
        String tagName = "nonExistingTag";
        Table table = this.insertRows();
        Assert.assertNull((String)"The tag does not exists.", table.refs().get(tagName));
        this.sql("ALTER TABLE %s DROP TAG IF EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        Assert.assertNull((String)"The tag still does not exist.", table.refs().get(tagName));
        table.manageSnapshots().createTag(tagName, table.currentSnapshot().snapshotId()).commit();
        Assert.assertEquals((String)"The tag has been created successfully.", (long)table.currentSnapshot().snapshotId(), (long)((SnapshotRef)table.refs().get(tagName)).snapshotId());
        this.sql("ALTER TABLE %s DROP TAG IF EXISTS %s", new Object[]{this.tableName, tagName});
        table.refresh();
        Assert.assertNull((String)"The tag needs to be dropped.", table.refs().get(tagName));
    }

    @Test
    public void createOrReplaceWithNonExistingTag() throws NoSuchTableException {
        Table table = this.insertRows();
        String tagName = "t1";
        this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s CREATE OR REPLACE TAG %s AS OF VERSION %d", new Object[]{this.tableName, tagName, snapshotId});
        table.refresh();
        Assertions.assertThat((long)((SnapshotRef)table.refs().get(tagName)).snapshotId()).isEqualTo(snapshotId);
    }

    private Table insertRows() throws NoSuchTableException {
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        return this.validationCatalog.loadTable(this.tableIdent);
    }
}

