/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IcebergBucketTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergDayTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergHourTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergMonthTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergTruncateTransform;
import org.apache.spark.sql.catalyst.expressions.IcebergYearTransform;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.expressions.BucketTransform$;
import org.apache.spark.sql.connector.expressions.DaysTransform$;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform$;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.MonthsTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortValue$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.TruncateTransform$;
import org.apache.spark.sql.connector.expressions.YearsTransform$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ExtendedV2ExpressionUtils$
implements SQLConfHelper {
    public static final ExtendedV2ExpressionUtils$ MODULE$ = new ExtendedV2ExpressionUtils$();

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T extends NamedExpression> T resolveRef(NamedReference ref, LogicalPlan plan) {
        NamedExpression namedExpr;
        Option option = plan.resolve(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames())), this.conf().resolver());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                String name = CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ref.fieldNames()))).quoted();
                String outputString = ((IterableOnceOps)plan.output().map((Function1 & Serializable)x$1 -> x$1.name())).mkString(",");
                throw QueryCompilationErrors$.MODULE$.cannotResolveAttributeError(name, outputString);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        NamedExpression namedExpression = namedExpr = (NamedExpression)some.value();
        return (T)namedExpression;
    }

    public <T extends NamedExpression> Seq<T> resolveRefs(Seq<NamedReference> refs, LogicalPlan plan) {
        return (Seq)refs.map((Function1 & Serializable)ref -> MODULE$.resolveRef((NamedReference)ref, plan));
    }

    public Expression toCatalyst(org.apache.spark.sql.connector.expressions.Expression expr, LogicalPlan query) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option<Tuple2<Object, FieldReference>> option5;
        Transform transform;
        Option option6;
        Expression expression;
        Option option7;
        org.apache.spark.sql.connector.expressions.Expression expression2 = expr;
        if (expression2 != null && !(option7 = SortValue$.MODULE$.unapply(expression2)).isEmpty()) {
            org.apache.spark.sql.connector.expressions.Expression child = (org.apache.spark.sql.connector.expressions.Expression)((Tuple3)option7.get())._1();
            org.apache.spark.sql.connector.expressions.SortDirection direction = (org.apache.spark.sql.connector.expressions.SortDirection)((Tuple3)option7.get())._2();
            org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering = (org.apache.spark.sql.connector.expressions.NullOrdering)((Tuple3)option7.get())._3();
            Expression catalystChild = this.toCatalyst(child, query);
            expression = new SortOrder(catalystChild, this.toCatalyst(direction), this.toCatalyst(nullOrdering), (Seq)package$.MODULE$.Seq().empty());
        } else if (expression2 != null && !(option6 = IdentityTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            FieldReference ref = (FieldReference)option6.get();
            expression = (Expression)this.resolveRef((NamedReference)ref, query);
        } else if (expression2 instanceof Transform && BucketTransform$.MODULE$.unapply(transform = (Transform)expression2).isDefined()) {
            Expression expression3;
            Option option8;
            Transform transform2 = transform;
            if (transform2 != null && !(option8 = BucketTransform$.MODULE$.unapply(transform2)).isEmpty()) {
                int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option8.get())._1());
                Seq cols = (Seq)((Tuple3)option8.get())._2();
                expression3 = new IcebergBucketTransform(numBuckets, (Expression)this.resolveRef((NamedReference)cols.head(), query));
            } else {
                expression3 = (Expression)transform;
            }
            expression = expression3;
        } else if (expression2 != null && !(option5 = TruncateTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            int length = ((Tuple2)option5.get())._1$mcI$sp();
            FieldReference ref = (FieldReference)((Tuple2)option5.get())._2();
            expression = new IcebergTruncateTransform((Expression)this.resolveRef((NamedReference)ref, query), length);
        } else if (expression2 != null && !(option4 = YearsTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            FieldReference ref = (FieldReference)option4.get();
            expression = new IcebergYearTransform((Expression)this.resolveRef((NamedReference)ref, query));
        } else if (expression2 != null && !(option3 = MonthsTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            FieldReference ref = (FieldReference)option3.get();
            expression = new IcebergMonthTransform((Expression)this.resolveRef((NamedReference)ref, query));
        } else if (expression2 != null && !(option2 = DaysTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            FieldReference ref = (FieldReference)option2.get();
            expression = new IcebergDayTransform((Expression)this.resolveRef((NamedReference)ref, query));
        } else if (expression2 != null && !(option = HoursTransform$.MODULE$.unapply(expression2)).isEmpty()) {
            FieldReference ref = (FieldReference)option.get();
            expression = new IcebergHourTransform((Expression)this.resolveRef((NamedReference)ref, query));
        } else if (expression2 instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression2;
            expression = (Expression)this.resolveRef((NamedReference)fieldReference, query);
        } else {
            throw new AnalysisException(new StringBuilder(27).append(expr).append(" is not currently supported").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        return expression;
    }

    private SortDirection toCatalyst(org.apache.spark.sql.connector.expressions.SortDirection direction) {
        Ascending$ ascending$;
        org.apache.spark.sql.connector.expressions.SortDirection sortDirection = direction;
        if (org.apache.spark.sql.connector.expressions.SortDirection.ASCENDING.equals(sortDirection)) {
            ascending$ = Ascending$.MODULE$;
        } else if (org.apache.spark.sql.connector.expressions.SortDirection.DESCENDING.equals(sortDirection)) {
            ascending$ = Descending$.MODULE$;
        } else {
            throw new MatchError((Object)sortDirection);
        }
        return ascending$;
    }

    private NullOrdering toCatalyst(org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering) {
        NullsFirst$ nullsFirst$;
        org.apache.spark.sql.connector.expressions.NullOrdering nullOrdering2 = nullOrdering;
        if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
            nullsFirst$ = NullsFirst$.MODULE$;
        } else if (org.apache.spark.sql.connector.expressions.NullOrdering.NULLS_LAST.equals(nullOrdering2)) {
            nullsFirst$ = NullsLast$.MODULE$;
        } else {
            throw new MatchError((Object)nullOrdering2);
        }
        return nullsFirst$;
    }

    private ExtendedV2ExpressionUtils$() {
    }
}

