/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.ExtendedV2ExpressionUtils$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public final class ExtendedDistributionAndOrderingUtils$ {
    public static final ExtendedDistributionAndOrderingUtils$ MODULE$ = new ExtendedDistributionAndOrderingUtils$();

    public LogicalPlan prepareQuery(Write write, LogicalPlan query, SQLConf conf) {
        LogicalPlan logicalPlan;
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering) {
            LogicalPlan queryWithDistributionAndOrdering;
            LogicalPlan logicalPlan2;
            org.apache.spark.sql.catalyst.expressions.Expression[] expressionArray;
            RequiresDistributionAndOrdering requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2;
            int numPartitions = requiresDistributionAndOrdering.requiredNumPartitions();
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            if (distribution instanceof OrderedDistribution) {
                OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])orderedDistribution.ordering()), (Function1 & Serializable)e -> ExtendedV2ExpressionUtils$.MODULE$.toCatalyst((Expression)e, query), ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
            } else if (distribution instanceof ClusteredDistribution) {
                ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering()), (Function1 & Serializable)e -> ExtendedV2ExpressionUtils$.MODULE$.toCatalyst((Expression)e, query), ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
            } else if (distribution instanceof UnspecifiedDistribution) {
                expressionArray = (org.apache.spark.sql.catalyst.expressions.Expression[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(org.apache.spark.sql.catalyst.expressions.Expression.class));
            } else {
                throw new MatchError((Object)distribution);
            }
            org.apache.spark.sql.catalyst.expressions.Expression[] distribution2 = expressionArray;
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])distribution2))) {
                int finalNumPartitions = numPartitions > 0 ? numPartitions : conf.numShufflePartitions();
                logicalPlan2 = RepartitionByExpression$.MODULE$.apply((Seq)package$.MODULE$.ArraySeq().unsafeWrapArray((Object)distribution2), query, finalNumPartitions);
            } else {
                if (numPartitions > 0) {
                    throw QueryCompilationErrors$.MODULE$.numberOfPartitionsNotAllowedWithUnspecifiedDistributionError();
                }
                logicalPlan2 = query;
            }
            LogicalPlan queryWithDistribution = logicalPlan2;
            Seq ordering = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])requiresDistributionAndOrdering.requiredOrdering())).map((Function1 & Serializable)e -> ExtendedV2ExpressionUtils$.MODULE$.toCatalyst((Expression)e, query));
            logicalPlan = queryWithDistributionAndOrdering = ordering.nonEmpty() ? new Sort(ordering, false, queryWithDistribution) : queryWithDistribution;
        } else {
            logicalPlan = query;
        }
        return logicalPlan;
    }

    private ExtendedDistributionAndOrderingUtils$() {
    }
}

