/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfoImpl;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.V2ExistingTableWriteExec;
import org.apache.spark.sql.execution.datasources.v2.WritingSparkTask;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.LongAccumulator;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005M3q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003&\u0001\u0019\u0005a\u0005C\u0003A\u0001\u0011E\u0013I\u0001\u0011FqR,g\u000eZ3e-J*\u00050[:uS:<G+\u00192mK^\u0013\u0018\u000e^3Fq\u0016\u001c'B\u0001\u0004\b\u0003\t1(G\u0003\u0002\t\u0013\u0005YA-\u0019;bg>,(oY3t\u0015\tQ1\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001U\u0011Q\u0003L\n\u0004\u0001YQ\u0002CA\f\u0019\u001b\u0005)\u0011BA\r\u0006\u000551&gQ8n[\u0006tG-\u0012=fGB\u0011qcG\u0005\u00039\u0015\u0011\u0001D\u0016\u001aFq&\u001cH/\u001b8h)\u0006\u0014G.Z,sSR,W\t_3d\u0003\u0019!\u0013N\\5uIQ\tq\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\u0018aC<sSRLgn\u001a+bg.,\u0012a\n\t\u0004/!R\u0013BA\u0015\u0006\u0005A9&/\u001b;j]\u001e\u001c\u0006/\u0019:l)\u0006\u001c8\u000e\u0005\u0002,Y1\u0001A!B\u0017\u0001\u0005\u0004q#!A,\u0012\u0005=\u0012\u0004C\u0001\u00111\u0013\t\t\u0014EA\u0004O_RD\u0017N\\4\u0011\u0007MB$(D\u00015\u0015\t)d'A\u0003xe&$XM\u0003\u00028\u0017\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003sQ\u0012!\u0002R1uC^\u0013\u0018\u000e^3s!\tYd(D\u0001=\u0015\ti4\"\u0001\u0005dCR\fG._:u\u0013\tyDHA\u0006J]R,'O\\1m%><\u0018aC<sSR,w+\u001b;i-J\"\"A\u0011(\u0011\u0007\r[%H\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011qiE\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!AS\u0011\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&\"\u0011\u0015y5\u00011\u0001Q\u0003)\u0011\u0017\r^2i/JLG/\u001a\t\u0003gEK!A\u0015\u001b\u0003\u0015\t\u000bGo\u00195Xe&$X\r")
public interface ExtendedV2ExistingTableWriteExec<W extends DataWriter<InternalRow>>
extends V2ExistingTableWriteExec {
    public WritingSparkTask<W> writingTask();

    public static /* synthetic */ Seq writeWithV2$(ExtendedV2ExistingTableWriteExec $this, BatchWrite batchWrite) {
        return $this.writeWithV2(batchWrite);
    }

    default public Seq<InternalRow> writeWithV2(BatchWrite batchWrite) {
        RDD tempRdd = this.query().execute();
        RDD rdd = tempRdd.partitions().length == 0 ? ((SparkPlan)this).sparkContext().parallelize((Seq)package$.MODULE$.Seq().empty(), 1, ClassTag$.MODULE$.apply(InternalRow.class)) : tempRdd;
        WritingSparkTask task = this.writingTask();
        DataWriterFactory writerFactory = batchWrite.createBatchWriterFactory((PhysicalWriteInfo)new PhysicalWriteInfoImpl(rdd.getNumPartitions()));
        boolean useCommitCoordinator = batchWrite.useCommitCoordinator();
        WriterCommitMessage[] messages = new WriterCommitMessage[rdd.partitions().length];
        LongAccumulator totalNumRowsAccumulator = new LongAccumulator();
        ((Logging)this).logInfo((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Start processing data source write support: ").append(batchWrite).append(". ").toString()).append(new StringBuilder(30).append("The input RDD has ").append(messages.length).append(" partitions.").toString()).toString());
        Map writeMetrics = this.customMetrics();
        try {
            ((SparkPlan)this).sparkContext().runJob(rdd, (Function2 & Serializable)(context, iter) -> task.run(writerFactory, (TaskContext)context, (Iterator<InternalRow>)iter, useCommitCoordinator, (Map<String, SQLMetric>)writeMetrics), (Seq)ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())), (Function2 & Serializable)(index, result) -> {
                ExtendedV2ExistingTableWriteExec.$anonfun$writeWithV2$3(messages, totalNumRowsAccumulator, batchWrite, BoxesRunTime.unboxToInt((Object)index), result);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(DataWritingSparkTaskResult.class));
            ((Logging)this).logInfo((Function0 & Serializable)() -> new StringBuilder(41).append("Data source write support ").append(batchWrite).append(" is committing.").toString());
            batchWrite.commit(messages);
            ((Logging)this).logInfo((Function0 & Serializable)() -> new StringBuilder(37).append("Data source write support ").append(batchWrite).append(" committed.").toString());
            this.commitProgress_$eq((Option)new Some((Object)new StreamWriterCommitProgress(Predef$.MODULE$.Long2long(totalNumRowsAccumulator.value()))));
        }
        catch (Throwable cause) {
            Option option;
            ((Logging)this).logError((Function0 & Serializable)() -> new StringBuilder(39).append("Data source write support ").append(batchWrite).append(" is aborting.").toString());
            try {
                batchWrite.abort(messages);
            }
            catch (Throwable t) {
                ((Logging)this).logError((Function0 & Serializable)() -> new StringBuilder(43).append("Data source write support ").append(batchWrite).append(" failed to abort.").toString());
                cause.addSuppressed(t);
                throw QueryExecutionErrors$.MODULE$.writingJobFailedError(cause);
            }
            ((Logging)this).logError((Function0 & Serializable)() -> new StringBuilder(35).append("Data source write support ").append(batchWrite).append(" aborted.").toString());
            Throwable throwable = cause;
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw QueryExecutionErrors$.MODULE$.writingJobAbortedError(e);
            }
            throw cause;
        }
        return package$.MODULE$.Nil();
    }

    public static /* synthetic */ void $anonfun$writeWithV2$3(WriterCommitMessage[] messages$1, LongAccumulator totalNumRowsAccumulator$1, BatchWrite batchWrite$1, int index, DataWritingSparkTaskResult result) {
        WriterCommitMessage commitMessage;
        messages$1[index] = commitMessage = result.writerCommitMessage();
        totalNumRowsAccumulator$1.add(result.numRows());
        batchWrite$1.onDataWriterCommit(commitMessage);
    }

    public static void $init$(ExtendedV2ExistingTableWriteExec $this) {
    }
}

