/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.collection.Iterator;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u4q\u0001B\u0003\u0011\u0002\u0007\u0005A\u0003C\u0003/\u0001\u0011\u0005q\u0006C\u00034\u0001\u0019EA\u0007C\u0003P\u0001\u0011\u0005\u0001K\u0001\tXe&$\u0018N\\4Ta\u0006\u00148\u000eV1tW*\u0011aaB\u0001\u0003mJR!\u0001C\u0005\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0015-\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005UI4\u0003\u0002\u0001\u00179\t\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u000e\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0011\u001f\u0005\u001daunZ4j]\u001e\u0004\"aI\u0016\u000f\u0005\u0011JcBA\u0013)\u001b\u00051#BA\u0014\u0014\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002+1\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0017.\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQ\u0003$\u0001\u0004%S:LG\u000f\n\u000b\u0002aA\u0011q#M\u0005\u0003ea\u0011A!\u00168ji\u0006IqO]5uK\u001a+hn\u0019\u000b\u0004aUj\u0005\"\u0002\u001c\u0003\u0001\u00049\u0014AB<sSR,'\u000f\u0005\u00029s1\u0001A!\u0002\u001e\u0001\u0005\u0004Y$!A,\u0012\u0005qz\u0004CA\f>\u0013\tq\u0004DA\u0004O_RD\u0017N\\4\u0011\u0007\u0001+u)D\u0001B\u0015\t\u00115)A\u0003xe&$XM\u0003\u0002E\u0017\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003\r\u0006\u0013!\u0002R1uC^\u0013\u0018\u000e^3s!\tA5*D\u0001J\u0015\tQ5\"\u0001\u0005dCR\fG._:u\u0013\ta\u0015JA\u0006J]R,'O\\1m%><\b\"\u0002(\u0003\u0001\u00049\u0015a\u0001:po\u0006\u0019!/\u001e8\u0015\rE+&\fY3k!\t\u00116+D\u0001\u0006\u0013\t!VA\u0001\u000eECR\fwK]5uS:<7\u000b]1sWR\u000b7o\u001b*fgVdG\u000fC\u0003W\u0007\u0001\u0007q+A\u0007xe&$XM\u001d$bGR|'/\u001f\t\u0003\u0001bK!!W!\u0003#\u0011\u000bG/Y,sSR,'OR1di>\u0014\u0018\u0010C\u0003\\\u0007\u0001\u0007A,A\u0004d_:$X\r\u001f;\u0011\u0005usV\"A\u0007\n\u0005}k!a\u0003+bg.\u001cuN\u001c;fqRDQ!Y\u0002A\u0002\t\fA!\u001b;feB\u00191eY$\n\u0005\u0011l#\u0001C%uKJ\fGo\u001c:\t\u000b\u0019\u001c\u0001\u0019A4\u0002)U\u001cXmQ8n[&$8i\\8sI&t\u0017\r^8s!\t9\u0002.\u0003\u0002j1\t9!i\\8mK\u0006t\u0007\"B6\u0004\u0001\u0004a\u0017!D2vgR|W.T3ue&\u001c7\u000f\u0005\u0003ncR<hB\u00018p!\t)\u0003$\u0003\u0002q1\u00051\u0001K]3eK\u001aL!A]:\u0003\u00075\u000b\u0007O\u0003\u0002q1A\u0011Q.^\u0005\u0003mN\u0014aa\u0015;sS:<\u0007C\u0001=|\u001b\u0005I(B\u0001>\n\u0003\u0019iW\r\u001e:jG&\u0011A0\u001f\u0002\n'FcU*\u001a;sS\u000e\u0004")
public interface WritingSparkTask<W extends DataWriter<InternalRow>>
extends Logging,
Serializable {
    public void writeFunc(W var1, InternalRow var2);

    public static /* synthetic */ DataWritingSparkTaskResult run$(WritingSparkTask $this, DataWriterFactory writerFactory, TaskContext context, Iterator iter, boolean useCommitCoordinator, Map customMetrics) {
        return $this.run(writerFactory, context, (Iterator<InternalRow>)iter, useCommitCoordinator, (Map<String, SQLMetric>)customMetrics);
    }

    default public DataWritingSparkTaskResult run(DataWriterFactory writerFactory, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator, Map<String, SQLMetric> customMetrics) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        DataWriter dataWriter = writerFactory.createWriter(partId, taskId);
        LongRef count = LongRef.create((long)0L);
        return (DataWritingSparkTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                if (count$1.elem % (long)CustomMetrics$.MODULE$.NUM_ROWS_PER_UPDATE() == 0L) {
                    CustomMetrics$.MODULE$.updateMetrics((Seq)package$.MODULE$.ArraySeq().unsafeWrapArray((Object)dataWriter.currentMetricsValues()), customMetrics);
                }
                ++count$1.elem;
                this.writeFunc(dataWriter, (InternalRow)iter.next());
            }
            CustomMetrics$.MODULE$.updateMetrics((Seq)package$.MODULE$.ArraySeq().unsafeWrapArray((Object)dataWriter.currentMetricsValues()), customMetrics);
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    Throwable commitDeniedException = QueryExecutionErrors$.MODULE$.commitDeniedError(partId, taskId, attemptId, stageId, stageAttempt);
                    this.logInfo((Function0 & Serializable)() -> commitDeniedException.getMessage());
                    throw commitDeniedException;
                }
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Commit authorized for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").toString()).append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
                writerCommitMessage = dataWriter.commit();
            } else {
                this.logInfo((Function0 & Serializable)() -> new StringBuilder(36).append("Writer for partition ").append(context.partitionId()).append(" is committing.").toString());
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(39).append("Committed partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").toString()).append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
            return new DataWritingSparkTaskResult(count$1.elem, msg);
        }, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.logError((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("Aborting commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").toString()).append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
            dataWriter.abort();
            this.logError((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Aborted commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").toString()).append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
        }, (Function0)(JFunction0.mcV.sp & Serializable)() -> dataWriter.close());
    }

    public static void $init$(WritingSparkTask $this) {
    }
}

