/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.iceberg.ImmutableGenericPartitionStatisticsFile;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.PositionOutputStream;

public class ProcedureUtil {
    private ProcedureUtil() {
    }

    static PartitionStatisticsFile writePartitionStatsFile(long snapshotId, String statsLocation, FileIO fileIO) {
        try {
            PositionOutputStream positionOutputStream = fileIO.newOutputFile(statsLocation).create();
            positionOutputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ImmutableGenericPartitionStatisticsFile.builder().snapshotId(snapshotId).fileSizeInBytes(42L).path(statsLocation).build();
    }

    static String statsFileLocation(String tableLocation) {
        String statsFileName = "stats-file-" + UUID.randomUUID();
        return tableLocation.replaceFirst("file:", "") + "/metadata/" + statsFileName;
    }
}

