/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestAlterTableSchema
extends SparkExtensionsTestBase {
    public TestAlterTableSchema(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testSetIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start without identifier", (boolean)table.schema().identifierFieldIds().isEmpty());
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have new identifier field", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId()}), (Object)table.schema().identifierFieldIds());
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have new identifier field", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}), (Object)table.schema().identifierFieldIds());
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS location.lon", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have new identifier field", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("location.lon").fieldId()}), (Object)table.schema().identifierFieldIds());
    }

    @Test
    public void testSetInvalidIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, id2 bigint) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start without identifier", (boolean)table.schema().identifierFieldIds().isEmpty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS unknown", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("not found in current schema or added columns");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id2", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessageEndingWith("not a required field");
    }

    @Test
    public void testDropIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start without identifier", (boolean)table.schema().identifierFieldIds().isEmpty());
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have new identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}), (Object)table.schema().identifierFieldIds());
        this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS id", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should removed identifier field", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("location.lon").fieldId()}), (Object)table.schema().identifierFieldIds());
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have new identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("location.lon").fieldId()}), (Object)table.schema().identifierFieldIds());
        this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS id, location.lon", new Object[]{this.tableName});
        table.refresh();
        Assert.assertEquals((String)"Should have no identifier field", (Object)Sets.newHashSet(), (Object)table.schema().identifierFieldIds());
    }

    @Test
    public void testDropInvalidIdentifierFields() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string NOT NULL, location struct<lon:bigint NOT NULL,lat:bigint NOT NULL> NOT NULL) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertTrue((String)"Table should start without identifier", (boolean)table.schema().identifierFieldIds().isEmpty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS unknown", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: field unknown not found");
        this.sql("ALTER TABLE %s SET IDENTIFIER FIELDS id", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS data", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: data is not an identifier field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP IDENTIFIER FIELDS location.lon", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot complete drop identifier fields operation: location.lon is not an identifier field");
    }
}

