/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class TestAncestorsOfProcedure
extends SparkExtensionsTestBase {
    public TestAncestorsOfProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testAncestorOfUsingEmptyArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        Long currentTimestamp = table.currentSnapshot().timestampMillis();
        Long preSnapshotId = table.currentSnapshot().parentId();
        Long preTimeStamp = table.snapshot(table.currentSnapshot().parentId().longValue()).timestampMillis();
        List output = this.sql("CALL %s.system.ancestors_of('%s')", new Object[]{this.catalogName, this.tableIdent});
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{currentSnapshotId, currentTimestamp}), (Object)this.row(new Object[]{preSnapshotId, preTimeStamp})), output);
    }

    @Test
    public void testAncestorOfUsingSnapshotId() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        Long currentTimestamp = table.currentSnapshot().timestampMillis();
        Long preSnapshotId = table.currentSnapshot().parentId();
        Long preTimeStamp = table.snapshot(table.currentSnapshot().parentId().longValue()).timestampMillis();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{currentSnapshotId, currentTimestamp}), (Object)this.row(new Object[]{preSnapshotId, preTimeStamp})), this.sql("CALL %s.system.ancestors_of('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, currentSnapshotId}));
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{preSnapshotId, preTimeStamp})), this.sql("CALL %s.system.ancestors_of('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, preSnapshotId}));
    }

    @Test
    public void testAncestorOfWithRollBack() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        table.refresh();
        Long firstSnapshotId = table.currentSnapshot().snapshotId();
        Long firstTimestamp = table.currentSnapshot().timestampMillis();
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        table.refresh();
        Long secondSnapshotId = table.currentSnapshot().snapshotId();
        Long secondTimestamp = table.currentSnapshot().timestampMillis();
        this.sql("INSERT INTO TABLE %s VALUES (3, 'c')", new Object[]{this.tableName});
        table.refresh();
        Long thirdSnapshotId = table.currentSnapshot().snapshotId();
        Long thirdTimestamp = table.currentSnapshot().timestampMillis();
        this.sql("CALL %s.system.rollback_to_snapshot('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, secondSnapshotId});
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        table.refresh();
        Long fourthSnapshotId = table.currentSnapshot().snapshotId();
        Long fourthTimestamp = table.currentSnapshot().timestampMillis();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{fourthSnapshotId, fourthTimestamp}), (Object)this.row(new Object[]{secondSnapshotId, secondTimestamp}), (Object)this.row(new Object[]{firstSnapshotId, firstTimestamp})), this.sql("CALL %s.system.ancestors_of('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, fourthSnapshotId}));
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{thirdSnapshotId, thirdTimestamp}), (Object)this.row(new Object[]{secondSnapshotId, secondTimestamp}), (Object)this.row(new Object[]{firstSnapshotId, firstTimestamp})), this.sql("CALL %s.system.ancestors_of('%s', %dL)", new Object[]{this.catalogName, this.tableIdent, thirdSnapshotId}));
    }

    @Test
    public void testAncestorOfUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Long firstSnapshotId = table.currentSnapshot().snapshotId();
        Long firstTimestamp = table.currentSnapshot().timestampMillis();
        this.assertEquals("Procedure output must match", (List)ImmutableList.of((Object)this.row(new Object[]{firstSnapshotId, firstTimestamp})), this.sql("CALL %s.system.ancestors_of(snapshot_id => %dL, table => '%s')", new Object[]{this.catalogName, firstSnapshotId, this.tableIdent}));
    }

    @Test
    public void testInvalidAncestorOfCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.ancestors_of()", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [table]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.ancestors_of('')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for parameter 'table'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.ancestors_of('%s', 1.1)", new Object[]{this.catalogName, this.tableIdent})).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Wrong arg type for snapshot_id: cannot cast");
    }
}

