/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.extensions.IcebergParseException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestBranchDDL
extends SparkExtensionsTestBase {
    @Before
    public void before() {
        this.sql("CREATE TABLE %s (id INT, data STRING) USING iceberg", new Object[]{this.tableName});
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties()}};
    }

    public TestBranchDDL(String catalog, String implementation, Map<String, String> properties) {
        super(catalog, implementation, properties);
    }

    @Test
    public void testCreateBranch() throws NoSuchTableException {
        Table table = this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        long maxRefAge = 10L;
        this.sql("ALTER TABLE %s CREATE BRANCH %s AS OF VERSION %d RETAIN %d DAYS WITH SNAPSHOT RETENTION %d SNAPSHOTS %d days", new Object[]{this.tableName, branchName, snapshotId, maxRefAge, minSnapshotsToKeep, maxSnapshotAge});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, branchName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Ref b1 already exists");
    }

    @Test
    public void testCreateBranchOnEmptyTable() {
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, "b1"});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SnapshotRef mainRef = (SnapshotRef)table.refs().get("main");
        Assertions.assertThat((Object)mainRef).isNull();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assertions.assertThat((Object)ref).isNotNull();
        Assertions.assertThat((Integer)ref.minSnapshotsToKeep()).isNull();
        Assertions.assertThat((Long)ref.maxSnapshotAgeMs()).isNull();
        Assertions.assertThat((Long)ref.maxRefAgeMs()).isNull();
        Snapshot snapshot = table.snapshot(ref.snapshotId());
        Assertions.assertThat((Long)snapshot.parentId()).isNull();
        Assertions.assertThat((Iterable)snapshot.addedDataFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.removedDataFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.addedDeleteFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.removedDeleteFiles(table.io())).isEmpty();
    }

    @Test
    public void testCreateBranchUseDefaultConfig() throws NoSuchTableException {
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, branchName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchUseCustomMinSnapshotsToKeep() throws NoSuchTableException {
        Integer minSnapshotsToKeep = 2;
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s WITH SNAPSHOT RETENTION %d SNAPSHOTS", new Object[]{this.tableName, branchName, minSnapshotsToKeep});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchUseCustomMaxSnapshotAge() throws NoSuchTableException {
        long maxSnapshotAge = 2L;
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s WITH SNAPSHOT RETENTION %d DAYS", new Object[]{this.tableName, branchName, maxSnapshotAge});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertNotNull((Object)ref);
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchIfNotExists() throws NoSuchTableException {
        long maxSnapshotAge = 2L;
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s WITH SNAPSHOT RETENTION %d DAYS", new Object[]{this.tableName, branchName, maxSnapshotAge});
        this.sql("ALTER TABLE %s CREATE BRANCH IF NOT EXISTS %s", new Object[]{this.tableName, branchName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testCreateBranchUseCustomMinSnapshotsToKeepAndMaxSnapshotAge() throws NoSuchTableException {
        Integer minSnapshotsToKeep = 2;
        long maxSnapshotAge = 2L;
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s WITH SNAPSHOT RETENTION %d SNAPSHOTS %d DAYS", new Object[]{this.tableName, branchName, minSnapshotsToKeep, maxSnapshotAge});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertEquals((Object)minSnapshotsToKeep, (Object)ref.minSnapshotsToKeep());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxSnapshotAge), (long)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE BRANCH %s WITH SNAPSHOT RETENTION", new Object[]{this.tableName, branchName})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("no viable alternative at input 'WITH SNAPSHOT RETENTION'");
    }

    @Test
    public void testCreateBranchUseCustomMaxRefAge() throws NoSuchTableException {
        long maxRefAge = 10L;
        Table table = this.insertRows();
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE BRANCH %s RETAIN %d DAYS", new Object[]{this.tableName, branchName, maxRefAge});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(maxRefAge), (long)ref.maxRefAgeMs());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE BRANCH %s RETAIN", new Object[]{this.tableName, branchName})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE BRANCH %s RETAIN %s DAYS", new Object[]{this.tableName, branchName, "abc"})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s CREATE BRANCH %s RETAIN %d SECONDS", new Object[]{this.tableName, branchName, maxRefAge})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input 'SECONDS' expecting {'DAYS', 'HOURS', 'MINUTES'}");
    }

    @Test
    public void testDropBranch() throws NoSuchTableException {
        this.insertRows();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, table.currentSnapshot().snapshotId()).commit();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertEquals((long)table.currentSnapshot().snapshotId(), (long)ref.snapshotId());
        this.sql("ALTER TABLE %s DROP BRANCH %s", new Object[]{this.tableName, branchName});
        table.refresh();
        ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertNull((Object)ref);
    }

    @Test
    public void testDropBranchDoesNotExist() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP BRANCH %s", new Object[]{this.tableName, "nonExistingBranch"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Branch does not exist: nonExistingBranch");
    }

    @Test
    public void testDropBranchFailsForTag() throws NoSuchTableException {
        String tagName = "b1";
        Table table = this.insertRows();
        table.manageSnapshots().createTag(tagName, table.currentSnapshot().snapshotId()).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP BRANCH %s", new Object[]{this.tableName, tagName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Ref b1 is a tag not a branch");
    }

    @Test
    public void testDropBranchNonConformingName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP BRANCH %s", new Object[]{this.tableName, "123"})).isInstanceOf(IcebergParseException.class)).hasMessageContaining("mismatched input '123'");
    }

    @Test
    public void testDropMainBranchFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s DROP BRANCH main", new Object[]{this.tableName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot remove main branch");
    }

    @Test
    public void testDropBranchIfExists() {
        String branchName = "nonExistingBranch";
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertNull(table.refs().get(branchName));
        this.sql("ALTER TABLE %s DROP BRANCH IF EXISTS %s", new Object[]{this.tableName, branchName});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assert.assertNull((Object)ref);
    }

    private Table insertRows() throws NoSuchTableException {
        ImmutableList records = ImmutableList.of((Object)new SimpleRecord(Integer.valueOf(1), "a"), (Object)new SimpleRecord(Integer.valueOf(2), "b"));
        Dataset df = spark.createDataFrame((List)records, SimpleRecord.class);
        df.writeTo(this.tableName).append();
        return this.validationCatalog.loadTable(this.tableIdent);
    }

    @Test
    public void createOrReplace() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch(branchName, second).commit();
        this.sql("ALTER TABLE %s CREATE OR REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, first});
        table.refresh();
        Assertions.assertThat((long)((SnapshotRef)table.refs().get(branchName)).snapshotId()).isEqualTo(second);
    }

    @Test
    public void testCreateOrReplaceBranchOnEmptyTable() {
        String branchName = "b1";
        this.sql("ALTER TABLE %s CREATE OR REPLACE BRANCH %s", new Object[]{this.tableName, "b1"});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SnapshotRef mainRef = (SnapshotRef)table.refs().get("main");
        Assertions.assertThat((Object)mainRef).isNull();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assertions.assertThat((Object)ref).isNotNull();
        Assertions.assertThat((Integer)ref.minSnapshotsToKeep()).isNull();
        Assertions.assertThat((Long)ref.maxSnapshotAgeMs()).isNull();
        Assertions.assertThat((Long)ref.maxRefAgeMs()).isNull();
        Snapshot snapshot = table.snapshot(ref.snapshotId());
        Assertions.assertThat((Long)snapshot.parentId()).isNull();
        Assertions.assertThat((Iterable)snapshot.addedDataFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.removedDataFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.addedDeleteFiles(table.io())).isEmpty();
        Assertions.assertThat((Iterable)snapshot.removedDeleteFiles(table.io())).isEmpty();
    }

    @Test
    public void createOrReplaceWithNonExistingBranch() throws NoSuchTableException {
        Table table = this.insertRows();
        String branchName = "b1";
        this.insertRows();
        long snapshotId = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s CREATE OR REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, snapshotId});
        table.refresh();
        Assertions.assertThat((long)((SnapshotRef)table.refs().get(branchName)).snapshotId()).isEqualTo(snapshotId);
    }

    @Test
    public void replaceBranch() throws NoSuchTableException {
        Table table = this.insertRows();
        long first = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        long expectedMaxRefAgeMs = 1000L;
        table.manageSnapshots().createBranch(branchName, first).setMaxRefAgeMs(branchName, expectedMaxRefAgeMs).commit();
        this.insertRows();
        long second = table.currentSnapshot().snapshotId();
        this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, branchName, second});
        table.refresh();
        SnapshotRef ref = (SnapshotRef)table.refs().get(branchName);
        Assertions.assertThat((long)ref.snapshotId()).isEqualTo(second);
        Assertions.assertThat((Long)ref.maxRefAgeMs()).isEqualTo(expectedMaxRefAgeMs);
    }

    @Test
    public void replaceBranchDoesNotExist() throws NoSuchTableException {
        Table table = this.insertRows();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s REPLACE BRANCH %s AS OF VERSION %d", new Object[]{this.tableName, "someBranch", table.currentSnapshot().snapshotId()})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Branch does not exist: someBranch");
    }
}

