/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.parser.extensions.IcebergParseException;
import org.apache.spark.sql.catalyst.plans.logical.CallArgument;
import org.apache.spark.sql.catalyst.plans.logical.CallStatement;
import org.apache.spark.sql.catalyst.plans.logical.NamedArgument;
import org.apache.spark.sql.catalyst.plans.logical.PositionalArgument;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestCallStatementParser {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static SparkSession spark = null;
    private static ParserInterface parser = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").config("spark.sql.extensions", IcebergSparkSessionExtensions.class.getName()).config("spark.extra.prop", "value").getOrCreate();
        parser = spark.sessionState().sqlParser();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        parser = null;
        currentSpark.stop();
    }

    @Test
    public void testCallWithPositionalArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL c.n.func(1, '2', 3L, true, 1.0D, 9.0e1, 900e-1BD)");
        Assert.assertEquals((Object)ImmutableList.of((Object)"c", (Object)"n", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
        Assert.assertEquals((long)7L, (long)call.args().size());
        this.checkArg(call, 0, 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "2", DataTypes.StringType);
        this.checkArg(call, 2, 3L, DataTypes.LongType);
        this.checkArg(call, 3, true, DataTypes.BooleanType);
        this.checkArg(call, 4, 1.0, DataTypes.DoubleType);
        this.checkArg(call, 5, 90.0, DataTypes.DoubleType);
        this.checkArg(call, 6, new BigDecimal("900e-1"), (DataType)DataTypes.createDecimalType((int)3, (int)1));
    }

    @Test
    public void testCallWithNamedArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.func(c1 => 1, c2 => '2', c3 => true)");
        Assert.assertEquals((Object)ImmutableList.of((Object)"cat", (Object)"system", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
        Assert.assertEquals((long)3L, (long)call.args().size());
        this.checkArg(call, 0, "c1", 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
        this.checkArg(call, 2, "c3", true, DataTypes.BooleanType);
    }

    @Test
    public void testCallWithMixedArgs() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.func(c1 => 1, '2')");
        Assert.assertEquals((Object)ImmutableList.of((Object)"cat", (Object)"system", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
        Assert.assertEquals((long)2L, (long)call.args().size());
        this.checkArg(call, 0, "c1", 1, DataTypes.IntegerType);
        this.checkArg(call, 1, "2", DataTypes.StringType);
    }

    @Test
    public void testCallWithTimestampArg() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.func(TIMESTAMP '2017-02-03T10:37:30.00Z')");
        Assert.assertEquals((Object)ImmutableList.of((Object)"cat", (Object)"system", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
        Assert.assertEquals((long)1L, (long)call.args().size());
        this.checkArg(call, 0, Timestamp.from(Instant.parse("2017-02-03T10:37:30.00Z")), DataTypes.TimestampType);
    }

    @Test
    public void testCallWithVarSubstitution() throws ParseException {
        CallStatement call = (CallStatement)parser.parsePlan("CALL cat.system.func('${spark.extra.prop}')");
        Assert.assertEquals((Object)ImmutableList.of((Object)"cat", (Object)"system", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
        Assert.assertEquals((long)1L, (long)call.args().size());
        this.checkArg(call, 0, "value", DataTypes.StringType);
    }

    @Test
    public void testCallParseError() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> parser.parsePlan("CALL cat.system radish kebab")).isInstanceOf(IcebergParseException.class)).hasMessageContaining("missing '(' at 'radish'");
    }

    @Test
    public void testCallStripsComments() throws ParseException {
        ArrayList callStatementsWithComments = Lists.newArrayList((Object[])new String[]{"/* bracketed comment */  CALL cat.system.func('${spark.extra.prop}')", "/**/  CALL cat.system.func('${spark.extra.prop}')", "-- single line comment \n CALL cat.system.func('${spark.extra.prop}')", "-- multiple \n-- single line \n-- comments \n CALL cat.system.func('${spark.extra.prop}')", "/* select * from multiline_comment \n where x like '%sql%'; */ CALL cat.system.func('${spark.extra.prop}')", "/* {\"app\": \"dbt\", \"dbt_version\": \"1.0.1\", \"profile_name\": \"profile1\", \"target_name\": \"dev\", \"node_id\": \"model.profile1.stg_users\"} \n*/ CALL cat.system.func('${spark.extra.prop}')", "/* Some multi-line comment \n*/ CALL /* inline comment */ cat.system.func('${spark.extra.prop}') -- ending comment", "CALL -- a line ending comment\ncat.system.func('${spark.extra.prop}')"});
        for (String sqlText : callStatementsWithComments) {
            CallStatement call = (CallStatement)parser.parsePlan(sqlText);
            Assert.assertEquals((Object)ImmutableList.of((Object)"cat", (Object)"system", (Object)"func"), (Object)JavaConverters.seqAsJavaList((Seq)call.name()));
            Assert.assertEquals((long)1L, (long)call.args().size());
            this.checkArg(call, 0, "value", DataTypes.StringType);
        }
    }

    private void checkArg(CallStatement call, int index, Object expectedValue, DataType expectedType) {
        this.checkArg(call, index, null, expectedValue, expectedType);
    }

    private void checkArg(CallStatement call, int index, String expectedName, Object expectedValue, DataType expectedType) {
        CallArgument arg;
        if (expectedName != null) {
            arg = this.checkCast(call.args().apply(index), NamedArgument.class);
            Assert.assertEquals((Object)expectedName, (Object)arg.name());
        } else {
            arg = (CallArgument)call.args().apply(index);
            this.checkCast(arg, PositionalArgument.class);
        }
        Literal expectedExpr = this.toSparkLiteral(expectedValue, expectedType);
        Expression actualExpr = ((CallArgument)call.args().apply(index)).expr();
        Assert.assertEquals((String)"Arg types must match", (Object)expectedExpr.dataType(), (Object)actualExpr.dataType());
        Assert.assertEquals((String)"Arg must match", (Object)expectedExpr, (Object)actualExpr);
    }

    private Literal toSparkLiteral(Object value, DataType dataType) {
        return Literal$.MODULE$.create(value, dataType);
    }

    private <T> T checkCast(Object value, Class<T> expectedClass) {
        Assert.assertTrue((String)("Expected instance of " + expectedClass.getName()), (boolean)expectedClass.isInstance(value));
        return expectedClass.cast(value);
    }
}

