/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class TestFastForwardBranchProcedure
extends SparkExtensionsTestBase {
    public TestFastForwardBranchProcedure(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testFastForwardBranchUsingPositionalArgs() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.refresh();
        Snapshot currSnapshot = table.currentSnapshot();
        long sourceRef = currSnapshot.snapshotId();
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        table.refresh();
        long updatedRef = table.snapshot(newBranch).snapshotId();
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        List output = this.sql("CALL %s.system.fast_forward('%s', '%s', '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch});
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(0)).isEqualTo((Object)"main");
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(1)).isEqualTo((Object)sourceRef);
        Assertions.assertThat(Arrays.stream((Object[])output.get(0)).collect(Collectors.toList()).get(2)).isEqualTo((Object)updatedRef);
        this.assertEquals("Main branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
    }

    @Test
    public void testFastForwardBranchUsingNamedArgs() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        List output = this.sql("CALL %s.system.fast_forward(table => '%s', branch => '%s', to => '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch});
        this.assertEquals("Main branch should now have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
    }

    @Test
    public void testFastForwardWhenTargetIsNotAncestorFails() {
        this.sql("CREATE TABLE %s (id int NOT NULL, data string) USING iceberg", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", new Object[]{this.tableName});
        this.sql("INSERT INTO TABLE %s VALUES (2, 'b')", new Object[]{this.tableName});
        String newBranch = "testBranch";
        String tableNameWithBranch = String.format("%s.branch_%s", this.tableName, newBranch);
        this.sql("ALTER TABLE %s CREATE BRANCH %s", new Object[]{this.tableName, newBranch});
        this.sql("INSERT INTO TABLE %s VALUES(3,'c')", new Object[]{tableNameWithBranch});
        this.assertEquals("Main branch should not have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"})), this.sql("SELECT * FROM %s order by id", new Object[]{this.tableName}));
        this.assertEquals("Test branch should have the newly inserted record.", (List)ImmutableList.of((Object)this.row(new Object[]{1, "a"}), (Object)this.row(new Object[]{2, "b"}), (Object)this.row(new Object[]{3, "c"})), this.sql("SELECT * FROM %s order by id", new Object[]{tableNameWithBranch}));
        this.sql("INSERT INTO TABLE %s VALUES (4, 'd')", new Object[]{this.tableName});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward(table => '%s', branch => '%s', to => '%s')", new Object[]{this.catalogName, this.tableIdent, "main", newBranch})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot fast-forward: main is not an ancestor of testBranch");
    }

    @Test
    public void testInvalidFastForwardBranchCases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('test_table', branch => 'main', to => 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Named and positional arguments cannot be mixed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.custom.fast_forward('test_table', 'main', 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(NoSuchProcedureException.class)).hasMessage("Procedure custom.fast_forward not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('test_table', 'main')", new Object[]{this.catalogName})).isInstanceOf(AnalysisException.class)).hasMessage("Missing required parameters: [to]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CALL %s.system.fast_forward('', 'main', 'newBranch')", new Object[]{this.catalogName})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot handle an empty identifier for argument table");
    }
}

