/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.extensions.Employee;
import org.apache.iceberg.spark.extensions.TestDelete;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.spark.source.TestSparkCatalog;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

public class TestMergeOnReadDelete
extends TestDelete {
    public TestMergeOnReadDelete(String catalogName, String implementation, Map<String, String> config, String fileFormat, Boolean vectorized, String distributionMode, boolean fanoutEnabled, String branch, PlanningMode planningMode) {
        super(catalogName, implementation, config, fileFormat, vectorized, distributionMode, fanoutEnabled, branch, planningMode);
    }

    @Override
    protected Map<String, String> extraTableProperties() {
        return ImmutableMap.of((Object)"format-version", (Object)"2", (Object)"write.delete.mode", (Object)RowLevelOperationMode.MERGE_ON_READ.modeName());
    }

    @Parameterized.AfterParam
    public static void clearTestSparkCatalogCache() {
        TestSparkCatalog.clearTables();
    }

    @Test
    public void testDeleteWithExecutorCacheLocality() throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(this.tableName, new Employee(3, "hr"), new Employee(4, "hr"));
        this.append(this.tableName, new Employee(1, "hardware"), new Employee(2, "hardware"));
        this.append(this.tableName, new Employee(3, "hardware"), new Employee(4, "hardware"));
        this.createBranchIfNeeded();
        this.withSQLConf((Map)ImmutableMap.of((Object)"spark.sql.iceberg.executor-cache.locality.enabled", (Object)"true"), () -> {
            this.sql("DELETE FROM %s WHERE id = 1", new Object[]{this.commitTarget()});
            this.sql("DELETE FROM %s WHERE id = 3", new Object[]{this.commitTarget()});
            this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{4, "hardware"}), (Object)this.row(new Object[]{4, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC, dep ASC", new Object[]{this.selectTarget()}));
        });
    }

    @Test
    public void testDeleteFileGranularity() throws NoSuchTableException {
        this.checkDeleteFileGranularity(DeleteGranularity.FILE);
    }

    @Test
    public void testDeletePartitionGranularity() throws NoSuchTableException {
        this.checkDeleteFileGranularity(DeleteGranularity.PARTITION);
    }

    private void checkDeleteFileGranularity(DeleteGranularity deleteGranularity) throws NoSuchTableException {
        this.createAndInitPartitionedTable();
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", new Object[]{this.tableName, "write.delete.granularity", deleteGranularity});
        this.append(this.tableName, new Employee(1, "hr"), new Employee(2, "hr"));
        this.append(this.tableName, new Employee(3, "hr"), new Employee(4, "hr"));
        this.append(this.tableName, new Employee(1, "hardware"), new Employee(2, "hardware"));
        this.append(this.tableName, new Employee(3, "hardware"), new Employee(4, "hardware"));
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE id = 1 OR id = 3", new Object[]{this.commitTarget()});
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        Assertions.assertThat((Iterable)table.snapshots()).hasSize(5);
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)table, (String)this.branch);
        String expectedDeleteFilesCount = deleteGranularity == DeleteGranularity.FILE ? "4" : "2";
        this.validateMergeOnRead(currentSnapshot, "2", expectedDeleteFilesCount, null);
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{2, "hardware"}), (Object)this.row(new Object[]{2, "hr"}), (Object)this.row(new Object[]{4, "hardware"}), (Object)this.row(new Object[]{4, "hr"})), this.sql("SELECT * FROM %s ORDER BY id ASC, dep ASC", new Object[]{this.selectTarget()}));
    }

    @Test
    public void testCommitUnknownException() {
        this.createAndInitTable("id INT, dep STRING, category STRING");
        this.append(this.tableName, "{ \"id\": 1, \"dep\": \"hr\", \"category\": \"c1\"}");
        this.createBranchIfNeeded();
        this.append(this.commitTarget(), "{ \"id\": 2, \"dep\": \"hr\", \"category\": \"c1\" }\n{ \"id\": 3, \"dep\": \"hr\", \"category\": \"c1\" }");
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        RowDelta newRowDelta = table.newRowDelta();
        if (this.branch != null) {
            newRowDelta.toBranch(this.branch);
        }
        RowDelta spyNewRowDelta = (RowDelta)Mockito.spy((Object)newRowDelta);
        ((RowDelta)Mockito.doAnswer(invocation -> {
            newRowDelta.commit();
            throw new CommitStateUnknownException((Throwable)new RuntimeException("Datacenter on Fire"));
        }).when((Object)spyNewRowDelta)).commit();
        Table spyTable = (Table)Mockito.spy((Object)table);
        Mockito.when((Object)spyTable.newRowDelta()).thenReturn((Object)spyNewRowDelta);
        SparkTable sparkTable = this.branch == null ? new SparkTable(spyTable, false) : new SparkTable(spyTable, this.branch, false);
        ImmutableMap config = ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default");
        spark.conf().set("spark.sql.catalog.dummy_catalog", "org.apache.iceberg.spark.source.TestSparkCatalog");
        config.forEach((key, value) -> spark.conf().set("spark.sql.catalog.dummy_catalog." + key, value));
        Identifier ident = Identifier.of((String[])new String[]{"default"}, (String)"table");
        TestSparkCatalog.setTable((Identifier)ident, (org.apache.spark.sql.connector.catalog.Table)sparkTable);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DELETE FROM %s WHERE id = 2", new Object[]{"dummy_catalog.default.table"})).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on Fire");
        this.assertEquals("Should have expected rows", (List)ImmutableList.of((Object)this.row(new Object[]{1, "hr", "c1"}), (Object)this.row(new Object[]{3, "hr", "c1"})), this.sql("SELECT * FROM %s ORDER BY id", new Object[]{"dummy_catalog.default.table"}));
    }

    @Test
    public void testAggregatePushDownInMergeOnReadDelete() {
        this.createAndInitTable("id LONG, data INT");
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", new Object[]{this.tableName});
        this.createBranchIfNeeded();
        this.sql("DELETE FROM %s WHERE data = 1111", new Object[]{this.commitTarget()});
        String select = "SELECT max(data), min(data), count(data) FROM %s";
        List explain = this.sql("EXPLAIN " + select, new Object[]{this.selectTarget()});
        String explainString = ((Object[])explain.get(0))[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") || explainString.contains("min(data)") || explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"min/max/count not pushed down for deleted", (boolean)explainContainsPushDownAggregates);
        List actual = this.sql(select, new Object[]{this.selectTarget()});
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6666, 2222, 5L});
        this.assertEquals("min/max/count push down", expected, actual);
    }
}

