/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestMetaColumnProjectionWithStageScan
extends SparkExtensionsTestBase {
    public TestMetaColumnProjectionWithStageScan(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties()}};
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    private <T extends ScanTask> void stageTask(Table tab, String fileSetID, CloseableIterable<T> tasks) {
        ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
        taskSetManager.stageTasks(tab, fileSetID, (List)Lists.newArrayList(tasks));
    }

    @Test
    public void testReadStageTableMeta() throws Exception {
        String fileSetID;
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        table.refresh();
        String tableLocation = table.location();
        try (CloseableIterable tasks = table.newBatchScan().planFiles();){
            fileSetID = UUID.randomUUID().toString();
            this.stageTask(table, fileSetID, tasks);
            Dataset scanDF2 = spark.read().format("iceberg").option("file-open-cost", "0").option("scan-task-set-id", fileSetID).load(tableLocation);
            Assertions.assertThat((int)scanDF2.columns().length).isEqualTo(2);
        }
        tasks = table.newBatchScan().planFiles();
        try {
            fileSetID = UUID.randomUUID().toString();
            this.stageTask(table, fileSetID, tasks);
            Dataset scanDF = spark.read().format("iceberg").option("file-open-cost", "0").option("scan-task-set-id", fileSetID).load(tableLocation).select("*", new String[]{"_pos"});
            List rows = scanDF.collectAsList();
            ImmutableList expectedRows = ImmutableList.of((Object)this.row(new Object[]{1L, "a", 0L}), (Object)this.row(new Object[]{2L, "b", 1L}), (Object)this.row(new Object[]{3L, "c", 2L}), (Object)this.row(new Object[]{4L, "d", 3L}));
            this.assertEquals("result should match", (List)expectedRows, this.rowsToJava(rows));
        }
        finally {
            if (tasks != null) {
                tasks.close();
            }
        }
    }
}

