/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.commons.collections.ListUtils;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.extensions.SparkExtensionsTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadataTables
extends SparkExtensionsTestBase {
    public TestMetadataTables(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", new Object[]{this.tableName});
    }

    @Test
    public void testUnpartitionedTable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        Assert.assertEquals((String)"Should have 1 data manifest", (long)1L, (long)expectedDataManifests.size());
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".files")).schema();
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".delete_files");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        Assert.assertEquals((String)"Metadata table should return one delete file", (long)1L, (long)actualDeleteFiles.size());
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        Assert.assertEquals((String)"Should be one delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".data_files");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have two files manifest entries", (long)2L, (long)expectedFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(0)), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(1)), (Row)((Row)actualFiles.get(1)));
    }

    @Test
    public void testPartitionedTable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1 AND data='a'", new Object[]{this.tableName});
        this.sql("DELETE FROM %s WHERE id=1 AND data='b'", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)expectedDataManifests.size());
        Assert.assertEquals((String)"Should have 2 delete manifests", (long)2L, (long)expectedDeleteManifests.size());
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".delete_files")).schema();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assert.assertEquals((String)"Should have one delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".delete_files WHERE partition.data='a'");
        List actualDeleteFiles = actualDeleteFilesDs.collectAsList();
        Assert.assertEquals((String)"Metadata table should return one delete file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assert.assertEquals((String)"Should have one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".data_files WHERE partition.data='a'");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        List actualPartitionsWithProjection = spark.sql("SELECT file_count FROM " + this.tableName + ".partitions ").collectAsList();
        Assert.assertEquals((String)"Metadata table should return two partitions record", (long)2L, (long)actualPartitionsWithProjection.size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)1, (Object)((Row)actualPartitionsWithProjection.get(i)).get(0));
        }
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have two file manifest entries", (long)2L, (long)expectedFiles.size());
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files WHERE partition.data='a' ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(0)), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)((GenericData.Record)expectedFiles.get(1)), (Row)((Row)actualFiles.get(1)));
    }

    @Test
    public void testAllFilesUnpartitioned() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList records = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "b"), new SimpleRecord(Integer.valueOf(3), "c"), new SimpleRecord(Integer.valueOf(4), "d")});
        spark.createDataset((List)records, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        Assert.assertEquals((String)"Should have 1 data manifest", (long)1L, (long)expectedDataManifests.size());
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        List results = this.sql("DELETE FROM %s", new Object[]{this.tableName});
        Assert.assertEquals((String)"Table should be cleared", (long)0L, (long)results.size());
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".all_data_files")).schema();
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_data_files");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_delete_files");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        Assert.assertEquals((String)"Should be one delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        Assert.assertEquals((String)"Metadata table should return one delete file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_files ORDER BY content");
        List actualFiles = actualFilesDs.collectAsList();
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (List)expectedFiles, (List)actualFiles);
    }

    @Test
    public void testAllFilesPartitioned() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        this.sql("DELETE FROM %s WHERE id=1", new Object[]{this.tableName});
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)expectedDataManifests.size());
        List expectedDeleteManifests = TestHelpers.deleteManifests((Table)table);
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        List results = this.sql("DELETE FROM %s", new Object[]{this.tableName});
        Assert.assertEquals((String)"Table should be cleared", (long)0L, (long)results.size());
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        Schema filesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".all_data_files")).schema();
        Dataset actualDataFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_data_files WHERE partition.data='a'");
        List actualDataFiles = TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).collectAsList();
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)SparkSchemaUtil.convert((StructType)TestHelpers.selectNonDerived((Dataset)actualDataFilesDs).schema()).asStruct(), (GenericData.Record)expectedDataFiles.get(0), (Row)((Row)actualDataFiles.get(0)));
        Dataset actualDeleteFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_delete_files WHERE partition.data='a'");
        List actualDeleteFiles = TestHelpers.selectNonDerived((Dataset)actualDeleteFilesDs).collectAsList();
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.POSITION_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDeleteFilesDs), (GenericData.Record)expectedDeleteFiles.get(0), (Row)((Row)actualDeleteFiles.get(0)));
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".all_files WHERE partition.data='a' ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualDataFilesDs), (List)expectedFiles, (List)actualFiles);
    }

    @Test
    public void testMetadataLogEntries() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES ('format-version'='2')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        TableMetadata tableMetadata = ((HasTableOperations)table).operations().current();
        Snapshot currentSnapshot = tableMetadata.currentSnapshot();
        Snapshot parentSnapshot = table.snapshot(currentSnapshot.parentId().longValue());
        ArrayList metadataLogEntries = Lists.newArrayList((Iterable)tableMetadata.previousFiles());
        List metadataLogs = this.sql("SELECT * FROM %s.metadata_log_entries", new Object[]{this.tableName});
        this.assertEquals("MetadataLogEntriesTable result should match the metadataLog entries", (List)ImmutableList.of((Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).timestampMillis() * 1000L)), ((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).file(), null, null, null}), (Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).timestampMillis() * 1000L)), ((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).file(), parentSnapshot.snapshotId(), parentSnapshot.schemaId(), parentSnapshot.sequenceNumber()}), (Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(currentSnapshot.timestampMillis() * 1000L)), tableMetadata.metadataFileLocation(), currentSnapshot.snapshotId(), currentSnapshot.schemaId(), currentSnapshot.sequenceNumber()})), metadataLogs);
        List metadataLogWithFilters = this.sql("SELECT * FROM %s.metadata_log_entries WHERE latest_snapshot_id = %s", new Object[]{this.tableName, currentSnapshotId});
        Assert.assertEquals((String)"metadataLogEntries table should return 1 row", (long)1L, (long)metadataLogWithFilters.size());
        this.assertEquals("Result should match the latest snapshot entry", (List)ImmutableList.of((Object)this.row(new Object[]{DateTimeUtils.toJavaTimestamp((long)(tableMetadata.currentSnapshot().timestampMillis() * 1000L)), tableMetadata.metadataFileLocation(), tableMetadata.currentSnapshot().snapshotId(), tableMetadata.currentSnapshot().schemaId(), tableMetadata.currentSnapshot().sequenceNumber()})), metadataLogWithFilters);
        List metadataFiles = metadataLogEntries.stream().map(TableMetadata.MetadataLogEntry::file).collect(Collectors.toList());
        metadataFiles.add(tableMetadata.metadataFileLocation());
        List metadataLogWithProjection = this.sql("SELECT file FROM %s.metadata_log_entries", new Object[]{this.tableName});
        Assert.assertEquals((String)"metadataLogEntries table should return 3 rows", (long)3L, (long)metadataLogWithProjection.size());
        this.assertEquals("metadataLog entry should be of same file", metadataFiles.stream().map(xva$0 -> this.row(new Object[]{xva$0})).collect(Collectors.toList()), metadataLogWithProjection);
    }

    @Test
    public void testFilesTableTimeTravelWithSchemaEvolution() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        table.updateSchema().addColumn("category", (Type)Types.StringType.get()).commit();
        ArrayList newRecords = Lists.newArrayList((Object[])new Row[]{RowFactory.create((Object[])new Object[]{3, "b", "c"}), RowFactory.create((Object[])new Object[]{4, "b", "c"})});
        StructType newSparkSchema = SparkSchemaUtil.convert((Schema)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"category", (Type)Types.StringType.get())}));
        spark.createDataFrame((List)newRecords, newSparkSchema).coalesce(1).writeTo(this.tableName).append();
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        Dataset actualFilesDs = spark.sql("SELECT * FROM " + this.tableName + ".files VERSION AS OF " + currentSnapshotId + " ORDER BY content");
        List actualFiles = TestHelpers.selectNonDerived((Dataset)actualFilesDs).collectAsList();
        Schema entriesTableSchema = Spark3Util.loadIcebergTable((SparkSession)spark, (String)(this.tableName + ".entries")).schema();
        List expectedDataManifests = TestHelpers.dataManifests((Table)table);
        List<GenericData.Record> expectedFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assert.assertEquals((String)"actualFiles size should be 2", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)expectedFiles.get(0), (Row)((Row)actualFiles.get(0)));
        TestHelpers.assertEqualsSafe((Types.StructType)TestHelpers.nonDerivedSchema((Dataset)actualFilesDs), (GenericData.Record)expectedFiles.get(1), (Row)((Row)actualFiles.get(1)));
        Assert.assertEquals((String)"expectedFiles and actualFiles size should be the same", (long)actualFiles.size(), (long)expectedFiles.size());
    }

    @Test
    public void testSnapshotReferencesMetatable() throws Exception {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (data) TBLPROPERTIES('format-version'='2', 'write.delete.mode'='merge-on-read')", new Object[]{this.tableName});
        ArrayList recordsA = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "a"), new SimpleRecord(Integer.valueOf(2), "a")});
        spark.createDataset((List)recordsA, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        ArrayList recordsB = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(Integer.valueOf(1), "b"), new SimpleRecord(Integer.valueOf(2), "b")});
        spark.createDataset((List)recordsB, Encoders.bean(SimpleRecord.class)).coalesce(1).writeTo(this.tableName).append();
        Table table = Spark3Util.loadIcebergTable((SparkSession)spark, (String)this.tableName);
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("testBranch", currentSnapshotId.longValue()).setMaxRefAgeMs("testBranch", 10L).setMinSnapshotsToKeep("testBranch", 20).setMaxSnapshotAgeMs("testBranch", 30L).commit();
        table.manageSnapshots().createTag("testTag", currentSnapshotId.longValue()).setMaxRefAgeMs("testTag", 50L).commit();
        List references = spark.sql("SELECT * FROM " + this.tableName + ".refs").collectAsList();
        Assert.assertEquals((String)"Refs table should return 3 rows", (long)3L, (long)references.size());
        List branches = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE type='BRANCH'").collectAsList();
        Assert.assertEquals((String)"Refs table should return 2 branches", (long)2L, (long)branches.size());
        List tags = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE type='TAG'").collectAsList();
        Assert.assertEquals((String)"Refs table should return 1 tag", (long)1L, (long)tags.size());
        List mainBranch = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'main' AND type='BRANCH'").collectAsList();
        Assert.assertEquals((Object)"main", (Object)((Row)mainBranch.get(0)).getAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)((Row)mainBranch.get(0)).getAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)((Row)mainBranch.get(0)).getAs("snapshot_id"));
        List testBranch = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'testBranch' AND type='BRANCH'").collectAsList();
        Assert.assertEquals((Object)"testBranch", (Object)((Row)testBranch.get(0)).getAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)((Row)testBranch.get(0)).getAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)((Row)testBranch.get(0)).getAs("snapshot_id"));
        Assert.assertEquals((Object)10L, (Object)((Row)testBranch.get(0)).getAs("max_reference_age_in_ms"));
        Assert.assertEquals((Object)20, (Object)((Row)testBranch.get(0)).getAs("min_snapshots_to_keep"));
        Assert.assertEquals((Object)30L, (Object)((Row)testBranch.get(0)).getAs("max_snapshot_age_in_ms"));
        List testTag = spark.sql("SELECT * FROM " + this.tableName + ".refs WHERE name = 'testTag' AND type='TAG'").collectAsList();
        Assert.assertEquals((Object)"testTag", (Object)((Row)testTag.get(0)).getAs("name"));
        Assert.assertEquals((Object)"TAG", (Object)((Row)testTag.get(0)).getAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)((Row)testTag.get(0)).getAs("snapshot_id"));
        Assert.assertEquals((Object)50L, (Object)((Row)testTag.get(0)).getAs("max_reference_age_in_ms"));
        List testTagProjection = spark.sql("SELECT name,type,snapshot_id,max_reference_age_in_ms,min_snapshots_to_keep FROM " + this.tableName + ".refs where type='TAG'").collectAsList();
        Assert.assertEquals((Object)"testTag", (Object)((Row)testTagProjection.get(0)).getAs("name"));
        Assert.assertEquals((Object)"TAG", (Object)((Row)testTagProjection.get(0)).getAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)((Row)testTagProjection.get(0)).getAs("snapshot_id"));
        Assert.assertEquals((Object)50L, (Object)((Row)testTagProjection.get(0)).getAs("max_reference_age_in_ms"));
        Assert.assertNull((Object)((Row)testTagProjection.get(0)).getAs("min_snapshots_to_keep"));
        List mainBranchProjection = spark.sql("SELECT name, type FROM " + this.tableName + ".refs WHERE name = 'main' AND type = 'BRANCH'").collectAsList();
        Assert.assertEquals((Object)"main", (Object)((Row)mainBranchProjection.get(0)).getAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)((Row)mainBranchProjection.get(0)).getAs("type"));
        List testBranchProjection = spark.sql("SELECT type, name, max_reference_age_in_ms, snapshot_id FROM " + this.tableName + ".refs WHERE name = 'testBranch' AND type = 'BRANCH'").collectAsList();
        Assert.assertEquals((Object)"testBranch", (Object)((Row)testBranchProjection.get(0)).getAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)((Row)testBranchProjection.get(0)).getAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)((Row)testBranchProjection.get(0)).getAs("snapshot_id"));
        Assert.assertEquals((Object)10L, (Object)((Row)testBranchProjection.get(0)).getAs("max_reference_age_in_ms"));
    }

    private List<GenericData.Record> expectedEntries(Table table, FileContent expectedContent, Schema entriesTableSchema, List<ManifestFile> manifestsToExplore, String partValue) throws IOException {
        ArrayList expected = Lists.newArrayList();
        for (ManifestFile manifest : manifestsToExplore) {
            InputFile in = table.io().newInputFile(manifest.path());
            AvroIterable rows = Avro.read((InputFile)in).project(entriesTableSchema).build();
            try {
                for (GenericData.Record record : rows) {
                    GenericData.Record file;
                    if ((Integer)record.get("status") >= 2 || !this.partitionMatch(file = (GenericData.Record)record.get("data_file"), partValue)) continue;
                    TestHelpers.asMetadataRecord((GenericData.Record)file, (FileContent)expectedContent);
                    expected.add(file);
                }
            }
            finally {
                if (rows == null) continue;
                rows.close();
            }
        }
        return expected;
    }

    private boolean partitionMatch(GenericData.Record file, String partValue) {
        if (partValue == null) {
            return true;
        }
        GenericData.Record partition = (GenericData.Record)file.get(4);
        return partValue.equals(partition.get(0).toString());
    }
}

